package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditWriteOffService;
import com.biz.crm.dms.business.costpool.credit.sdk.constant.CreditConstant;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTempWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditWriteOffVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWriteOffVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.TimeUnit;

/**
 * 授信管理: CreditWriteOffVo: 授信核销信息
 *
 * @author ning.zhang
 * @date 2021/12/22
 */
@Slf4j
@RestController
@RequestMapping("/v1/credit/writeOff")
@Api(tags = "授信管理: CreditWriteOffVo: 授信核销信息")
public class CreditWriteOffVoController {

  @Autowired(required = false)
  private CreditWriteOffVoService creditWriteOffVoService;
  @Autowired(required = false)
  private RedisMutexService redisMutexService;
  @Autowired(required = false)
  private CreditWriteOffService creditWriteOffService;
  @Autowired(required = false)
  private CreditVoService creditVoService;

  /**
   * 新增授信核销
   *
   * @param dto 参数dto
   * @return 操作结果
   */
  @ApiOperation(value = "新增授信核销")
  @PostMapping("")
  public Result<?> create(@RequestBody CreditWriteOffDto dto) {
    String lockKey = this.creditVoService.buildCashLockKeyByCustomerCode(dto.getCustomerCode());
    Validate.isTrue(this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, CreditConstant.CREDIT_TRY_LOCK_OUT_TIME)
        , CreditConstant.CREDIT_LOCK_FAIL_MESSAGE);
    try {
      this.creditWriteOffService.create(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      this.redisMutexService.unlock(lockKey);
    }
  }

  /**
   * 普通授信核销信息分页列表
   *
   * @param dto 参数dto
   * @return 授信核销分页信息
   */
  @ApiOperation(value = "普通授信核销信息分页列表")
  @GetMapping("findByConditions")
  public Result<Page<CreditWriteOffVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "CreditWriteOffPageDto", value = "分页Dto") CreditWriteOffPageDto dto) {
    try {
      return Result.ok(this.creditWriteOffVoService.findByConditions(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 临时授信核销明细分页列表
   *
   * @param dto 参数dto
   * @return 授信核销分页信息
   */
  @ApiOperation(value = "临时授信核销明细分页列表")
  @GetMapping("findByCreditTempWriteOffPageDto")
  public Result<Page<CreditWriteOffVo>> findByCreditTempWriteOffPageDto(@PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "CreditTempWriteOffPageDto", value = "分页Dto") CreditTempWriteOffPageDto dto) {
    try {
      return Result.ok(this.creditWriteOffVoService.findByCreditTempWriteOffPageDto(pageable, dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
