package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 授信资金实体类
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditCashEntity", description = "授信资金实体类")
@Entity
@TableName("dms_credit_cash")
@Table(name = "dms_credit_cash", indexes = {
    @Index(name = "dms_credit_cash_index1", columnList = "credit_id", unique = true),
    @Index(name = "dms_credit_cash_index2", columnList = "tenant_code"),
    @Index(name = "dms_credit_cash_index3", columnList = "customer_code"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_credit_cash", comment = "授信资金表")
public class CreditCashEntity extends TenantOpEntity {

  private static final long serialVersionUID = -4887256158070482922L;

  /**
   * 授信ID
   */
  @ApiModelProperty(value = "授信ID")
  @Column(name = "credit_id", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '授信ID'")
  private String creditId;

  /**
   * 授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))
   */
  @ApiModelProperty("授信类型(normalCredit:普通授信,temporaryCredit:临时授信)")
  @Column(name = "credit_type", columnDefinition = "VARCHAR(30) COMMENT '授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))'")
  private String creditType;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
  private String customerCode;

  /**
   * 授信额度
   */
  @ApiModelProperty("授信额度")
  @Column(name = "credit_amount", columnDefinition = "decimal(20,4) COMMENT '授信额度'")
  private BigDecimal creditAmount;

  /**
   * 冻结额度
   */
  @ApiModelProperty("冻结额度")
  @Column(name = "freeze_amount", columnDefinition = "decimal(20,4) COMMENT '冻结额度'")
  private BigDecimal freezeAmount;

  /**
   * 占用额度
   */
  @ApiModelProperty("占用额度")
  @Column(name = "occupy_amount", columnDefinition = "decimal(20,4) COMMENT '占用额度'")
  private BigDecimal occupyAmount;

  /**
   * 可用额度
   */
  @ApiModelProperty("可用额度")
  @Column(name = "can_use_amount", columnDefinition = "decimal(20,4) COMMENT '可用额度'")
  private BigDecimal canUseAmount;

  /**
   * 核销金额
   */
  @ApiModelProperty("核销金额")
  @Column(name = "write_off_amount", columnDefinition = "decimal(20,4) COMMENT '核销金额'")
  private BigDecimal writeOffAmount;
}
