package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 授信资金流水拆分细则实体类
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditCashFlowItemEntity", description = "授信资金流水拆分细则实体类")
@Entity
@TableName("dms_credit_cash_flow_item")
@Table(name = "dms_credit_cash_flow_item", indexes = {
    @Index(name = "dms_credit_operate_item_index1", columnList = "cash_flow_id"),
    @Index(name = "dms_credit_operate_item_index2", columnList = "tenant_code"),
    @Index(name = "dms_credit_operate_item_index3", columnList = "credit_id"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_credit_cash_flow_item", comment = "授信资金流水拆分细则表")
public class CreditCashFlowItemEntity extends TenantOpEntity {

  private static final long serialVersionUID = -6798834790821180730L;

  /**
   * 授信资金流水ID
   */
  @ApiModelProperty("授信资金流水ID")
  @Column(name = "cash_flow_id", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '授信资金流水ID'")
  private String cashFlowId;

  /**
   * 操作细则金额
   */
  @ApiModelProperty("操作细则金额")
  @Column(name = "item_amount", columnDefinition = "decimal(20,4) COMMENT '操作细则金额'")
  private BigDecimal itemAmount;


  /**
   * 授信ID
   */
  @ApiModelProperty("授信ID")
  @Column(name = "credit_id", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '授信ID'")
  private String creditId;
}
