package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 授信回款上账实体类
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditDownUpAccountEntity", description = "授信回款上账实体类")
@Entity
@TableName("dms_credit_down_up_account")
@Table(name = "dms_credit_down_up_account", indexes = {
    @Index(name = "dms_credit_down_up_account_index1", columnList = "credit_id"),
    @Index(name = "dms_credit_down_up_account_index2", columnList = "tenant_code"),
    @Index(name = "dms_credit_down_up_account_index3", columnList = "cash_serial_number"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_credit_down_up_account", comment = "授信回款上账表")
public class CreditDownUpAccountEntity extends TenantOpEntity {

  private static final long serialVersionUID = 7212035952830716719L;

  /**
   * 授信ID
   */
  @ApiModelProperty(value = "授信ID")
  @Column(name = "credit_id", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '授信ID'")
  private String creditId;

  /**
   * 回款/上账金额
   */
  @ApiModelProperty("回款/上账金额")
  @Column(name = "down_up_amount", columnDefinition = "decimal(20,4) COMMENT '回款/上账金额'")
  private BigDecimal downUpAmount;

  /**
   * 单据编码
   */
  @ApiModelProperty("单据编码")
  @Column(name = "order_code", columnDefinition = "VARCHAR(64) COMMENT '单据编码'")
  private String orderCode;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  @Column(name = "order_type", columnDefinition = "VARCHAR(64) COMMENT '单据类型'")
  private String orderType;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @Column(name = "remark", columnDefinition = "varchar(400) COMMENT '备注'")
  private String remark;

  /**
   * 资金流水号
   */
  @ApiModelProperty("资金流水号")
  @Column(name = "cash_serial_number", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '资金流水号'")
  private String cashSerialNumber;

  /**
   * 文件信息
   */
  @ApiModelProperty("公告文件信息")
  @Transient
  @TableField(exist = false)
  private List<CreditFileEntity> fileList;
}
