package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.WorkflowFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 授信实体类
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditEntity", description = "授信实体类")
@Entity
@TableName("dms_credit")
@Table(name = "dms_credit", indexes = {
    @Index(name = "dms_credit_index1", columnList = "credit_code"),
    @Index(name = "dms_credit_index2", columnList = "tenant_code,credit_code",unique = true),
    @Index(name = "dms_credit_index3", columnList = "customer_code"),
    @Index(name = "dms_credit_index4", columnList = "credit_start_time"),
    @Index(name = "dms_credit_index5", columnList = "credit_end_time"),
    @Index(name = "dms_credit_index6", columnList = "repay_end_time"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_credit", comment = "授信表")
public class CreditEntity extends WorkflowFlagOpEntity {

  private static final long serialVersionUID = -3214065542196203280L;

  /**
   * 授信编码
   */
  @ApiModelProperty("授信编码")
  @Column(name = "credit_code", columnDefinition = "VARCHAR(64) COMMENT '授信编码'")
  private String creditCode;

  /**
   * 授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))
   */
  @ApiModelProperty("授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))")
  @Column(name = "credit_type", columnDefinition = "VARCHAR(30) NOT NULL COMMENT '授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))'")
  private String creditType;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "customer_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '客户编码'")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @Column(name = "customer_name", columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
  private String customerName;

  /**
   * 授信额度
   */
  @ApiModelProperty("授信额度")
  @Column(name = "credit_amount", columnDefinition = "decimal(20,4) COMMENT '授信额度'")
  private BigDecimal creditAmount;

  /**
   * 授信开始时间
   */
  @ApiModelProperty("授信开始时间")
  @Column(name = "credit_start_time", columnDefinition = "datetime COMMENT '授信开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditStartTime;

  /**
   * 授信结束时间
   */
  @ApiModelProperty("授信结束时间")
  @Column(name = "credit_end_time", columnDefinition = "datetime COMMENT '授信结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditEndTime;

  /**
   * 还款截止时间
   */
  @ApiModelProperty("还款截止时间")
  @Column(name = "repay_end_time", columnDefinition = "datetime COMMENT '还款截止时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date repayEndTime;
}
