package com.biz.crm.dms.business.costpool.credit.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 授信占用实体类
 *
 * @author pengxi
 * @date 2022/6/24
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditOccupyEntity", description = "授信占用实体类")
@Entity
@TableName("dms_credit_occupy")
@Table(name = "dms_credit_occupy", indexes = {
    @Index(name = "dms_credit_occupy_index1", columnList = "tenant_code"),
    @Index(name = "dms_credit_occupy_index2", columnList = "occupy_type"),
    @Index(name = "dms_credit_occupy_index3", columnList = "business_order_code"),
})
@org.hibernate.annotations.Table(appliesTo = "dms_credit_occupy", comment = "授信占用实体类")
public class CreditOccupyEntity extends TenantOpEntity {

  /**
   * 资金流水号
   */
  @ApiModelProperty("资金流水号")
  @Column(name = "cash_serial_number", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '资金流水号'")
  private String cashSerialNumber;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  @Column(name = "order_type", columnDefinition = "VARCHAR(64) COMMENT '单据类型'")
  private String orderType;

  /**
   * 业务单据号
   */
  @ApiModelProperty("业务单据号")
  @Column(name = "business_order_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '业务单据号'")
  private String businessOrderCode;

  /**
   * 占用类型：occupy 占用；release 释放
   */
  @ApiModelProperty("占用类型：occupy 占用；release 释放")
  @Column(name = "occupy_type", columnDefinition = "VARCHAR(64) COMMENT '占用类型：occupy 占用；release 释放'")
  private String occupyType;

  /**
   * 占用金额（授信功能的占用是站在可用余额的角度，即，占用时金额存负数；释放时金额存正数）
   */
  @ApiModelProperty("占用金额（授信功能的占用是站在可用余额的角度，即，占用时金额存负数；释放时金额存正数）")
  @Column(name = "occupy_amount", columnDefinition = "decimal(20,4) NOT NULL COMMENT '占用金额'")
  private BigDecimal occupyAmount;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @Column(name = "remark", columnDefinition = "varchar(400) COMMENT '备注'")
  private String remark;

}
