package com.biz.crm.dms.business.costpool.credit.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowCustomerDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowPageDto;
import org.apache.ibatis.annotations.Param;

/**
 * 授信资金流水表的mybatis-plus接口类 {@link CreditCashFlowEntity}
 *
 * @author ning.zhang
 * @date 2021-12-15 16:48:26
 */
public interface CreditCashFlowMapper extends BaseMapper<CreditCashFlowEntity> {

  /**
   * 授信资金流水分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<CreditCashFlowEntity>授信资金流水
   */
  Page<CreditCashFlowEntity> findByConditions(Page<CreditCashFlowEntity> page, @Param("dto") CreditCashFlowPageDto dto);

  /**
   * 获取已使用授信客户数量
   *
   * @param tenantCode 租户编码
   * @return 已使用授信客户数量
   */
  Integer findHaveUseCustomerNum(@Param("tenantCode") String tenantCode);

  /**
   * 客户-商城授信资金流水分页列表
   *
   * @param page
   * @param dto
   * @return
   */
  Page<CreditCashFlowEntity> findByCreditCashFlowCustomerDto(Page<CreditCashFlowEntity> page, @Param("dto") CreditCashFlowCustomerDto dto);
}

