package com.biz.crm.dms.business.costpool.credit.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditCashModelDto;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 授信资金表的mybatis-plus接口类 {@link CreditCashEntity}
 *
 * @author ning.zhang
 * @date 2021-12-15 16:48:26
 */
public interface CreditCashMapper extends BaseMapper<CreditCashEntity> {

  /**
   * 内部模板复合查询授信资金列表
   *
   * @param dto 参数dto
   * @return 授信资金列表
   */
  List<CreditCashEntity> findByCreditCashModelDto(@Param("dto") CreditCashModelDto dto);

  /**
   * 获取已使用总金额
   *
   * @param tenantCode 租户编码
   * @return 已使用总金额
   */
  BigDecimal findHaveUseTotalAmount(@Param("tenantCode") String tenantCode);
}

