package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditCashFlowItemMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 授信资金流水拆分细则表的数据库访问类 {@link CreditCashFlowItemEntity}
 *
 * @author ning.zhang
 * @date 2021-12-15 16:48:44
 */
@Component
public class CreditCashFlowItemRepository extends ServiceImpl<CreditCashFlowItemMapper, CreditCashFlowItemEntity> {

  /**
   * 通过资金流水ID集合获取资金流水明细信息
   *
   * @param cashFlowIds 资金流水ID集合
   * @return 资金流水明细信息
   */
  public List<CreditCashFlowItemEntity> findByCashFlowIds(List<String> cashFlowIds) {
    return this.lambdaQuery()
        .in(CreditCashFlowItemEntity::getCashFlowId, cashFlowIds)
        .list();
  }

}
