package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditCashFlowMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowCustomerDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowPageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 授信资金流水表的数据库访问类 {@link CreditCashFlowEntity}
 *
 * @author ning.zhang
 * @date 2021-12-15 16:48:26
 */
@Component
public class CreditCashFlowRepository extends ServiceImpl<CreditCashFlowMapper, CreditCashFlowEntity> {

  /**
   * 授信资金流水分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditCashFlowEntity>授信资金流水
   */
  public Page<CreditCashFlowEntity> findByConditions(Pageable pageable, CreditCashFlowPageDto dto) {
    Page<CreditCashFlowEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 获取已使用授信客户数量
   *
   * @param tenantCode 租户编码
   * @return 已使用授信客户数量
   */
  public Integer findHaveUseCustomerNum(String tenantCode) {
    return this.baseMapper.findHaveUseCustomerNum(tenantCode);
  }

  /**
   * 通过资金流水号集合获取资金流水信息
   *
   * @param cashSerialNumbers 资金流水号集合
   * @param tenantCode        租户编码
   * @return 资金流水信息
   */
  public List<CreditCashFlowEntity> findByCashSerialNumbers(List<String> cashSerialNumbers, String tenantCode) {
    return this.lambdaQuery()
        .eq(CreditCashFlowEntity::getTenantCode, tenantCode)
        .in(CreditCashFlowEntity::getCashSerialNumber, cashSerialNumbers)
        .list();
  }

  /**
   * 客户-商城授信资金流水分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditCashFlowEntity>授信资金流水
   */
  public Page<CreditCashFlowEntity> findByCreditCashFlowCustomerDto(Pageable pageable, CreditCashFlowCustomerDto dto) {
    Page<CreditCashFlowEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByCreditCashFlowCustomerDto(page, dto);
  }
}
