package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditCashMapper;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditCashModelDto;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * 授信资金表的数据库访问类 {@link CreditCashEntity}
 *
 * @author ning.zhang
 * @date 2021-12-15 16:48:26
 */
@Component
public class CreditCashRepository extends ServiceImpl<CreditCashMapper, CreditCashEntity> {

  /**
   * 通过授信ID获取授信资金
   *
   * @param creditId 授信ID
   * @return 授信资金
   */
  public CreditCashEntity findByCreditId(String creditId) {
    return this.lambdaQuery()
        .eq(CreditCashEntity::getCreditId, creditId)
        .one();
  }

  /**
   * 内部模板复合查询授信资金列表
   *
   * @param dto 参数dto
   * @return 授信资金列表
   */
  public List<CreditCashEntity> findByCreditCashModelDto(CreditCashModelDto dto) {
    return this.baseMapper.findByCreditCashModelDto(dto);
  }

  /**
   * 获取已使用总金额
   *
   * @param tenantCode 租户编码
   * @return 已使用总金额
   */
  public BigDecimal findHaveUseTotalAmount(String tenantCode) {
    return this.baseMapper.findHaveUseTotalAmount(tenantCode);
  }

  /**
   * 通过授信ID集合获取授信资金
   *
   * @param creditIds 授信ID集合
   * @return 授信资金
   */
  public List<CreditCashEntity> findByCreditIds(List<String> creditIds) {
    return this.lambdaQuery()
        .in(CreditCashEntity::getCreditId, creditIds)
        .list();
  }
}
