package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditCustomerVoMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTemporaryCustomerPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCustomerVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 授信客户信息VO的数据库访问类
 *
 * @author ning.zhang
 * @date 2022/1/17
 */
@Component
public class CreditCustomerVoRepository {

  @Autowired(required = false)
  private CreditCustomerVoMapper creditCustomerVoMapper;

  /**
   * 临时授信客户信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditCustomerVo> 临时授信客户分页信息
   */
  public Page<CreditCustomerVo> findByCreditTemporaryCustomerPageDto(Pageable pageable, CreditTemporaryCustomerPageDto dto) {
    Page<CreditCustomerVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.creditCustomerVoMapper.findByCreditTemporaryCustomerPageDto(page, dto);
  }

}
