package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditFileEntity;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditFileMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 授信相关文件表的数据库访问类 {@link CreditFileEntity}
 *
 * @author ning.zhang
 * @date 2021-12-14 20:09:45
 */
@Component
public class CreditFileRepository extends ServiceImpl<CreditFileMapper, CreditFileEntity> {

  /**
   * 通过业务ID集合删除文件信息
   *
   * @param businessIds 业务ID集合
   */
  public void deleteByBusinessIds(List<String> businessIds) {
    this.lambdaUpdate()
        .in(CreditFileEntity::getBusinessId, businessIds)
        .remove();
  }

  /**
   * 根据业务ID和文件类型查询附件信息
   *
   * @param businessId 业务ID
   * @param fileType   文件类型
   * @return 附件信息
   */
  public List<CreditFileEntity> findByBusinessIdAndFileType(String businessId, String fileType) {
    return this.lambdaQuery()
        .eq(CreditFileEntity::getBusinessId, businessId)
        .eq(CreditFileEntity::getFileType, fileType)
        .list();
  }
}
