package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditPayEntity;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditPayMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 授信支付实体类的数据库访问类 {@link CreditPayEntity}
 *
 * @author ning.zhang
 * @date 2022-01-20 15:20:07
 */
@Component
public class CreditPayRepository extends ServiceImpl<CreditPayMapper, CreditPayEntity> {

  /**
   * 通过业务单据号获取授信支付信息
   *
   * @param businessOrderCode 业务单据号
   * @param tenantCode        租户编码
   * @return 授信支付信息
   */
  public CreditPayEntity findByBusinessOrderCode(String businessOrderCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(CreditPayEntity::getTenantCode, tenantCode)
        .eq(CreditPayEntity::getBusinessOrderCode, businessOrderCode)
        .one();
  }

  /**
   * 查询授信支付信息
   *
   * @param dto        参数dto
   * @return 授信支付信息
   */
  public List<CreditPayEntity> findByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
    return this.lambdaQuery()
        .in(!CollectionUtils.isEmpty(dto.getCashSerialNumbers()), CreditPayEntity::getCashSerialNumber, dto.getCashSerialNumbers())
        .in(!CollectionUtils.isEmpty(dto.getOrderCodes()), CreditPayEntity::getBusinessOrderCode, dto.getOrderCodes())
        .eq(CreditPayEntity::getTenantCode, dto.getTenantCode())
        .list();
  }
}
