package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditRefundEntity;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditRefundMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 授信退款实体类的数据库访问类 {@link CreditRefundEntity}
 *
 * @author ning.zhang
 * @date 2022-01-20 16:19:15
 */
@Component
public class CreditRefundRepository extends ServiceImpl<CreditRefundMapper, CreditRefundEntity> {

  /**
   * 通过业务单据号获取授信退款信息
   *
   * @param businessOrderCode 业务单据号
   * @param tenantCode        租户编码
   * @return 授信支付信息
   */
  public List<CreditRefundEntity> findByBusinessOrderCode(String businessOrderCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(CreditRefundEntity::getTenantCode, tenantCode)
        .eq(CreditRefundEntity::getBusinessOrderCode, businessOrderCode)
        .list();
  }

  /**
   * 查询授信退款信息
   *
   * @param dto        参数dto
   * @return 授信退款信息
   */
  public List<CreditRefundEntity> findByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
    return this.lambdaQuery()
        .in(!CollectionUtils.isEmpty(dto.getCashSerialNumbers()), CreditRefundEntity::getCashSerialNumber, dto.getCashSerialNumbers())
        .in(!CollectionUtils.isEmpty(dto.getOrderCodes()), CreditRefundEntity::getBusinessOrderCode, dto.getOrderCodes())
        .eq(CreditRefundEntity::getTenantCode, dto.getTenantCode())
        .list();
  }
}
