package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditVoMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTemporaryPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 授信VO的数据库访问类
 *
 * @author ning.zhang
 * @date 2021-12-14 20:08:46
 */
@Component
public class CreditVoRepository {

  @Autowired(required = false)
  private CreditVoMapper creditVoMapper;

  /**
   * 普通授信信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditVo> 普通授信分页信息
   */
  public Page<CreditVo> findByCreditPageDto(Pageable pageable, CreditPageDto dto) {
    Page<CreditVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.creditVoMapper.findByCreditPageDto(page, dto);
  }

  /**
   * 临时授信信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditVo> 临时授信信息分页
   */
  public Page<CreditVo> findByCreditTemporaryPageDto(Pageable pageable, CreditTemporaryPageDto dto) {
    pageable = org.apache.commons.lang3.ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    Page<CreditVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.creditVoMapper.findByCreditTemporaryPageDto(page, dto);
  }

  /**
   * 通过普通授信ID获取授信信息
   *
   * @param commonCreditId  普通授信ID
   * @return  授信信息
   */
  public CreditVo findByCommonCreditId(String commonCreditId) {
    return this.creditVoMapper.findByCommonCreditId(commonCreditId);
  }

  /**
   * 客户-商城授信头展示查询
   * @param dto
   * @return
   */
  public CreditVo findByTotalCreditDto(CreditDto dto) {
    return this.creditVoMapper.findByTotalCreditDto(dto);
  }

  /**
   * 商城-临时授信申请记录信息分页列表
   * @param page
   * @param dto
   * @return
   */
  public Page<CreditVo> findApplyRecordByCreditTemporaryPageDto(Page<CreditVo> page, CreditTemporaryPageDto dto) {
    return this.creditVoMapper.findApplyRecordByCreditTemporaryPageDto(page,dto);
  }


  /**
   * 通过普通授信编码获取授信信息
   *
   * @param creditCode  普通授信ID
   * @return  授信信息
   */
  public CreditVo findByCreditCode(String creditCode) {
    return this.creditVoMapper.findByCreditCode(creditCode);
  }
}
