package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditWriteOffItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditWriteOffItemMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffItemPageDto;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 授信核销明细表的数据库访问类 {@link CreditWriteOffItemEntity}
 *
 * @author ning.zhang
 * @date 2021-12-21 15:27:47
 */
@Component
public class CreditWriteOffItemRepository extends ServiceImpl<CreditWriteOffItemMapper, CreditWriteOffItemEntity> {

  /**
   * 通过单据编码集合获取核销明细信息
   *
   * @param orderCodes 单据编码集合
   * @param tenantCode 租户编码
   * @return 核销明细信息
   */
  public List<CreditWriteOffItemEntity> findByOrderCodes(List<String> orderCodes, String tenantCode) {
    return this.lambdaQuery()
        .eq(CreditWriteOffItemEntity::getTenantCode, tenantCode)
        .in(CreditWriteOffItemEntity::getOrderCode, orderCodes)
        .list();
  }

  /**
   * 授信核销明细分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditWriteOffItemEntity>  授信核销明细分页信息
   */
  public Page<CreditWriteOffItemEntity> findByConditions(Pageable pageable, CreditWriteOffItemPageDto dto) {
    Page<CreditWriteOffItemEntity> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.baseMapper.findByConditions(page, dto);
  }
}
