package com.biz.crm.dms.business.costpool.credit.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.local.mapper.CreditWriteOffVoMapper;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditRepayNoticeDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTempWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWaitWriteOffDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWriteOffVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 授信核销信息VO的数据库访问类
 *
 * @author ning.zhang
 * @date 2021/12/22
 */
@Component
public class CreditWriteOffVoRepository {

  @Autowired(required = false)
  private CreditWriteOffVoMapper creditWriteOffVoMapper;

  /**
   * 普通授信核销信息分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditWriteOffVo> 授信核销分页信息
   */
  public Page<CreditWriteOffVo> findByConditions(Pageable pageable, CreditWriteOffPageDto dto) {
    Page<CreditWriteOffVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.creditWriteOffVoMapper.findByConditions(page, dto);
  }

  /**
   * 临时授信核销明细分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<CreditWriteOffVo> 授信核销分页信息
   */
  public Page<CreditWriteOffVo> findByCreditTempWriteOffPageDto(Pageable pageable, CreditTempWriteOffPageDto dto) {
    Page<CreditWriteOffVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.creditWriteOffVoMapper.findByCreditTempWriteOffPageDto(page, dto);
  }

  /**
   * 获取授信待核销明细信息
   *
   * @param dto 参数dto
   * @return 授信待核销信息
   */
  public List<CreditWriteOffVo> findByCreditWaitWriteOffDto(CreditWaitWriteOffDto dto) {
    return this.creditWriteOffVoMapper.findByCreditWaitWriteOffDto(dto);
  }

  /**
   * 获取授信还款通知待核销信息
   *
   * @param dto 参数dto
   * @return 授信还款通知待核销信息
   */
  public List<CreditWriteOffVo> findByCreditRepayNoticeDto(CreditRepayNoticeDto dto) {
    return this.creditWriteOffVoMapper.findByCreditRepayNoticeDto(dto);
  }
}
