package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRepository;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditCashModelDto;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashVoService;
import com.biz.crm.dms.business.costpool.credit.local.service.helper.CreditServiceHelper;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 授信资金服务接口实现类
 *
 * @author ning.zhang
 * @date 2021/12/16
 */
@Service
public class CreditCashVoServiceImpl implements CreditCashVoService {

  @Autowired(required = false)
  private CreditCashRepository creditCashRepository;
  @Autowired(required = false)
  private CreditRepository creditRepository;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private CreditServiceHelper creditServiceHelper;

  @Override
  public Map<String, CreditCashVo> findByCreditCashModelDto(CreditCashModelDto dto) {
    Map<String, CreditCashVo> resultMap = Maps.newHashMap();
    if (Objects.isNull(dto)) {
      return resultMap;
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    List<CreditCashEntity> entities = this.creditCashRepository.findByCreditCashModelDto(dto);
    if (CollectionUtils.isEmpty(entities)) {
      return resultMap;
    }
    List<CreditEntity> creditEntities = creditRepository.listByIds(entities.stream().map(CreditCashEntity::getCreditId).collect(Collectors.toList()));
    Map<String, CreditEntity> creditEntityMap = creditEntities.stream().collect(Collectors.toMap(CreditEntity::getId, t -> t, (key1, key2) -> key2));
    resultMap = entities.stream().collect(Collectors.toMap(CreditCashEntity::getCreditId, cashEntity -> {
      CreditCashVo cashModelVo = this.nebulaToolkitService.copyObjectByWhiteList(cashEntity, CreditCashVo.class, HashSet.class, ArrayList.class);
      CreditEntity creditEntity = creditEntityMap.get(cashEntity.getCreditId());
      cashModelVo.setCreditStartTime(creditEntity.getCreditStartTime());
      cashModelVo.setCreditType(creditEntity.getCreditType());
      cashModelVo.setCreditEndTime(creditEntity.getCreditEndTime());
      cashModelVo.setHaveUseAmount(this.creditServiceHelper.calculateHaveUseAmount(cashEntity));
      return cashModelVo;
    }));
    return resultMap;
  }
}
