package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCustomerVoRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCustomerVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTemporaryCustomerPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCustomerVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 授信客户vo服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/1/17
 */
@Service
public class CreditCustomerVoServiceImpl implements CreditCustomerVoService {

  @Autowired(required = false)
  private CreditCustomerVoRepository creditCustomerVoRepository;
  @Autowired(required = false)
  private CustomerVoService customerVoService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<CreditCustomerVo> findByCreditTemporaryCustomerPageDto(Pageable pageable, CreditTemporaryCustomerPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new CreditTemporaryCustomerPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    dto.setNowDate(new Date());
    Page<CreditCustomerVo> page = this.creditCustomerVoRepository.findByCreditTemporaryCustomerPageDto(pageable, dto);
    Page<CreditCustomerVo> resultPage = new Page<>(pageable.getPageNumber(), pageable.getPageSize(), 0);
    resultPage.setTotal(page.getTotal());
    if (CollectionUtils.isEmpty(page.getRecords())) {
      return resultPage;
    }
    List<String> customerCodes = page.getRecords().stream().map(CreditCustomerVo::getCustomerCode).collect(Collectors.toList());
    List<CustomerVo> list = this.customerVoService.findByCustomerCodes(customerCodes);
    if (CollectionUtils.isEmpty(customerCodes)) {
      return resultPage;
    }
    List<CreditCustomerVo> voList = list.stream().map(customerVo -> {
      CreditCustomerVo vo = this.nebulaToolkitService.copyObjectByWhiteList(customerVo, CreditCustomerVo.class, HashSet.class, ArrayList.class);
      if (CollectionUtils.isEmpty(customerVo.getOrgList())) {
        return vo;
      }
      List<String> orgNameList = Lists.newArrayList();
      List<String> orgNCodeList = Lists.newArrayList();
      customerVo.getOrgList().forEach(customerRelateOrgVo -> {
        orgNameList.add(customerRelateOrgVo.getOrgName());
        orgNCodeList.add(customerRelateOrgVo.getOrgCode());
      });
      vo.setOrgCode(String.join(",", orgNCodeList));
      vo.setOrgName(String.join(",", orgNameList));
      return vo;
    }).collect(Collectors.toList());
    resultPage.setRecords(voList);
    return resultPage;
  }

}
