package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.dms.business.costpool.credit.local.repository.CreditReconcileStatsVoRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditReconcileStatsDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditReconcileStatsVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditReconcileStatsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * 授信对账函数据统计VO服务接口实现类
 *
 * @author ning.zhang
 * @date 2022/4/8
 */
@Slf4j
@Service
public class CreditReconcileStatsVoServiceImpl implements CreditReconcileStatsVoService {

  @Autowired(required = false)
  private CreditReconcileStatsVoRepository creditReconcileStatsVoRepository;

  @Override
  public CreditReconcileStatsVo findByCreditReconcileStatsDto(CreditReconcileStatsDto dto) {
    if (Objects.isNull(dto) || StringUtils.isBlank(dto.getCustomerCode())
        || Objects.isNull(dto.getEndTime()) || Objects.isNull(dto.getStartTime())) {
      return null;
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    CreditReconcileStatsVo reconcileStatsVo = this.creditReconcileStatsVoRepository.findByCreditReconcileStatsDto(dto);
    if (Objects.nonNull(reconcileStatsVo) && Objects.nonNull(reconcileStatsVo.getUserAmount())) {
      reconcileStatsVo.setUserAmount(BigDecimal.ZERO.subtract(reconcileStatsVo.getUserAmount()));
    }
    return reconcileStatsVo;
  }
}
