package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditWriteOffItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditWriteOffItemRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditWriteOffItemService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffItemPageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 授信核销明细表服务实现类
 *
 * @author ning.zhang
 * @date 2021-12-21 15:27:47
 */
@Slf4j
@Service("creditWriteOffItemService")
public class CreditWriteOffItemServiceImpl implements CreditWriteOffItemService {

  @Autowired(required = false)
  private CreditWriteOffItemRepository creditWriteOffItemRepository;

  @Override
  public Page<CreditWriteOffItemEntity> findByConditions(Pageable pageable, CreditWriteOffItemPageDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new CreditWriteOffItemPageDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    if (StringUtils.isBlank(dto.getCreditId())) {
      return new Page<>(pageable.getPageNumber(), pageable.getPageSize(), 0);
    }
    return this.creditWriteOffItemRepository.findByConditions(pageable, dto);
  }
}
