package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.dms.business.costpool.credit.local.repository.CreditWriteOffStatsVoRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffInfoStatsDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditWriteOffStatsVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWriteOffStatsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 授信核销统计信息VO服务接口实现类
 *
 * @author ning.zhang
 * @date 2021/12/23
 */
@Component
public class CreditWriteOffStatsVoServiceImpl implements CreditWriteOffStatsVoService {

  @Autowired(required = false)
  private CreditWriteOffStatsVoRepository creditWriteOffStatsVoRepository;

  @Override
  public CreditWriteOffStatsVo findByCreditWriteOffInfoStatsDto(CreditWriteOffInfoStatsDto dto) {
    if (Objects.isNull(dto) || StringUtils.isBlank(dto.getCreditType())) {
      return null;
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.creditWriteOffStatsVoRepository.findByCreditWriteOffInfoStatsDto(dto);
  }
}
