package com.biz.crm.dms.business.costpool.credit.local.service.observer;

import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditReconcileStatsDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditPoolTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditReconcileStatsVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditReconcileStatsVo;
import com.biz.crm.dms.business.costpool.sdk.enums.CostPoolSummaryEnum;
import com.biz.crm.dms.business.costpool.sdk.observer.CostPoolAmountStatisticsObserver;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 费用池金额统计客户授信观察者
 *
 * @author ning.zhang
 * @date 2022/4/11
 */
@Service
@Slf4j
public class CostPoolAmountStatisticsCreditImpl implements CostPoolAmountStatisticsObserver {

  @Autowired(required = false)
  private CreditReconcileStatsVoService creditReconcileStatsVoService;

  @Override
  public List<CostPoolAmountStatisticsVo> findAmountStatisticsVoByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate) {
    List<CostPoolAmountStatisticsVo> resultList = Lists.newArrayList();
    CreditReconcileStatsDto dto = new CreditReconcileStatsDto();
    dto.setCustomerCode(customerCode);
    dto.setEndTime(endDate);
    dto.setStartTime(beginDate);
    CreditReconcileStatsVo creditReconcileStatsVo = this.creditReconcileStatsVoService.findByCreditReconcileStatsDto(dto);
    if (Objects.isNull(creditReconcileStatsVo)) {
      return resultList;
    }
    for (CostPoolSummaryEnum costPoolSummaryEnum : CostPoolSummaryEnum.values()) {
      CostPoolAmountStatisticsVo costPoolAmountStatisticsVo = new CostPoolAmountStatisticsVo();
      costPoolAmountStatisticsVo.setPoolType(CreditPoolTypeEnum.CREDIT.getKey());
      costPoolAmountStatisticsVo.setSummary(costPoolSummaryEnum.getKey());
      switch (costPoolSummaryEnum) {
        case BEGIN:
          costPoolAmountStatisticsVo.setTotalAmount(creditReconcileStatsVo.getBeginBalance());
          break;
        case ON:
          costPoolAmountStatisticsVo.setTotalAmount(creditReconcileStatsVo.getUpAccountAmount());
          break;
        case USE:
          costPoolAmountStatisticsVo.setTotalAmount(creditReconcileStatsVo.getUserAmount());
          break;
        case END:
          costPoolAmountStatisticsVo.setTotalAmount(creditReconcileStatsVo.getEndBalance());
          break;
        case TOTAL:
          costPoolAmountStatisticsVo.setTotalAmount(creditReconcileStatsVo.getCreditAmount());
          break;
        case OCCUPY:
          costPoolAmountStatisticsVo.setTotalAmount(creditReconcileStatsVo.getOccupyAmount());
          break;
        default:
      }
      resultList.add(costPoolAmountStatisticsVo);
    }
    return resultList;
  }
}
