package com.biz.crm.dms.business.costpool.credit.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditCashModelDto;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashVoService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditOccupyService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditPayService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditRefundService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditOccupyDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPayDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditRefundDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCostPoolVo;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 折扣池实现费用池观察者相关接口
 *
 * @author songjingen
 */
@Component("CostPoolCreditStrategyImpl")
public class CostPoolCreditStrategyImpl implements CostPoolStrategy {

  @Autowired(required = false)
  @Qualifier("CostPoolCreditRegisterImpl")
  private CostPoolRegister costPoolRegister;
  @Autowired(required = false)
  private CreditPayService creditPayService;
  @Autowired(required = false)
  private CreditRefundService creditRefundService;
  @Autowired(required = false)
  private CreditOccupyService creditOccupyService;
  @Autowired(required = false)
  private CreditCashVoService creditCashVoService;

  @Override
  public String getPoolTypeRegisterKey() {
    return costPoolRegister.getKey();
  }

  @Override
  public List<CostPoolVo> onRequestCostPoolVos(CostPoolDto costPoolDto) {
    if (Objects.isNull(costPoolDto) || StringUtils.isBlank(costPoolDto.getCustomerCode())) {
      return Lists.newLinkedList();
    }
    CreditCashModelDto modelDto = new CreditCashModelDto();
    modelDto.setCustomerCode(costPoolDto.getCustomerCode());
    modelDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    modelDto.setInEffectiveTime(Boolean.TRUE);
    Map<String, CreditCashVo> cashModelMap = this.creditCashVoService.findByCreditCashModelDto(modelDto);
    if (cashModelMap.isEmpty()) {
      return Lists.newLinkedList();
    }
    List<CreditCashVo> creditCashList = Lists.newArrayList(cashModelMap.values());
    CreditCostPoolVo costPoolVo = new CreditCostPoolVo();
    costPoolVo.setCustomerCode(costPoolDto.getCustomerCode());
    costPoolVo.setFreezeAmount(BigDecimal.ZERO);
    costPoolVo.setHasUseAmount(BigDecimal.ZERO);
    costPoolVo.setTotalAmount(BigDecimal.ZERO);
    costPoolVo.setUsableAmount(BigDecimal.ZERO);
    creditCashList.forEach(creditCashVo -> {
      costPoolVo.setTotalAmount(costPoolVo.getTotalAmount().add(creditCashVo.getCreditAmount()));
      costPoolVo.setFreezeAmount(costPoolVo.getFreezeAmount().add(creditCashVo.getFreezeAmount()));
      costPoolVo.setHasUseAmount(costPoolVo.getHasUseAmount().add(creditCashVo.getHaveUseAmount()));
      costPoolVo.setUsableAmount(costPoolVo.getUsableAmount()
          .add(creditCashVo.getCanUseAmount().compareTo(BigDecimal.ZERO) > 0 ? creditCashVo.getCanUseAmount() : BigDecimal.ZERO));
    });
    return Lists.newArrayList(costPoolVo);
  }

  @Override
  public void onHandleAdjust(JSONObject jsonObject) {
    Validate.notNull(jsonObject,"授信变更操作时缺失参数对象！");
    String adjustTypeCode = jsonObject.getString("adjustTypeCode");
    Validate.notBlank(adjustTypeCode, "授信变更操作不能为空！");
    CashAdjustTypeEnum adjustTypeEnum = CashAdjustTypeEnum.getByDictCode(adjustTypeCode);
    Validate.notNull(adjustTypeEnum, "不支持的授信变更操作！");
    switch (adjustTypeEnum) {
      case CREDIT_REDUCE:
        CreditPayDto creditPayDto = JsonUtils.json2Obj(jsonObject.toJSONString(), CreditPayDto.class);
        this.creditPayService.create(creditPayDto);
        break;
      case CREDIT_RELEASE:
        CreditRefundDto creditRefundDto = JsonUtils.json2Obj(jsonObject.toJSONString(), CreditRefundDto.class);
        this.creditRefundService.create(creditRefundDto);
        break;
      case OCCUPY_USE:
          CreditOccupyDto creditOccupyUseDto = JsonUtils.json2Obj(jsonObject.toJSONString(), CreditOccupyDto.class);
          this.creditOccupyService.occupy(creditOccupyUseDto);
        break;
      case OCCUPY_RELEASE:
        CreditOccupyDto creditOccupyReleaseDto = JsonUtils.json2Obj(jsonObject.toJSONString(), CreditOccupyDto.class);
        this.creditOccupyService.release(creditOccupyReleaseDto);
        break;
      default:
        break;
    }
    // TODO 暂时保留原逻辑
    //if (CashAdjustTypeEnum.ORDER.getDictCode().equals(adjustTypeCode)) {
    //  CreditPayDto creditPayDto = JsonUtils.json2Obj(jsonObject.toJSONString(), CreditPayDto.class);
    //  this.creditPayService.create(creditPayDto);
    //} else if (CashAdjustTypeEnum.CLOSE_ORDER.getDictCode().equals(adjustTypeCode)) {
    //  CreditRefundDto creditRefundDto = JsonUtils.json2Obj(jsonObject.toJSONString(), CreditRefundDto.class);
    //  this.creditRefundService.create(creditRefundDto);
    //} else {
    //  throw new IllegalArgumentException("不支持的授信变更操作!");
    //}
  }
}
