/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditService;
import com.biz.crm.dms.business.costpool.credit.sdk.constant.CreditConstant;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditRepayNoticeDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditVoService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/credit/credit"})
@Api(tags={"\u6388\u4fe1\u7ba1\u7406: Credit: \u6388\u4fe1\u4fe1\u606f"})
public class CreditController {
    private static final Logger log = LoggerFactory.getLogger(CreditController.class);
    @Autowired(required=false)
    private CreditService creditService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private CreditVoService creditVoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u65b0\u589e\u6388\u4fe1")
    @PostMapping(value={""})
    public Result<?> create(@RequestBody CreditDto dto) {
        String lockKey = String.format("creditCreateLock_%s", TenantUtils.getTenantCode());
        Validate.isTrue((boolean)this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, CreditConstant.CREDIT_TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u5173\u8054\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            this.creditService.create(dto);
            Result result = Result.ok();
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5546\u57ce\u5ba2\u6237\u7533\u8bf7\u4e34\u65f6\u6388\u4fe1")
    @PostMapping(value={"/handleTemporaryCreditApply"})
    public Result<?> handleTemporaryCreditApply(@RequestBody CreditDto dto) {
        String lockKey = String.format("creditCreateLock_%s", TenantUtils.getTenantCode());
        Validate.isTrue((boolean)this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, CreditConstant.CREDIT_TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u5173\u8054\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            this.creditService.handleTemporaryCreditApply(dto);
            Result result = Result.ok();
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u66f4\u65b0\u6388\u4fe1\u4fe1\u606f")
    @PatchMapping(value={""})
    public Result<?> update(@RequestBody CreditDto dto) {
        String lockKey = this.creditVoService.buildCashLockKeyByCreditId(dto.getId());
        Validate.isTrue((boolean)this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, CreditConstant.CREDIT_TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u5173\u8054\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            this.creditService.update(dto);
            Result result = Result.ok();
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enableBatch"})
    public Result<?> enableBatch(@RequestBody List<String> customerCodes) {
        try {
            this.creditService.enableBatch(customerCodes);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disableBatch"})
    public Result<?> disableBatch(@RequestBody List<String> customerCodes) {
        try {
            this.creditService.disableBatch(customerCodes);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.creditService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d1\u9001\u8fd8\u6b3e\u901a\u77e5")
    @PostMapping(value={"/sendNotice"})
    public Result<?> sendNotice(@RequestBody CreditRepayNoticeDto dto) {
        try {
            this.creditService.sendNotice(dto);
            return Result.ok((String)"\u53d1\u9001\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

