/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTemporaryPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/credit/credit"})
@Api(tags={"\u6388\u4fe1\u7ba1\u7406: CreditVo: \u6388\u4fe1\u4fe1\u606f"})
public class CreditVoController {
    private static final Logger log = LoggerFactory.getLogger(CreditVoController.class);
    @Autowired(required=false)
    private CreditVoService creditVoService;

    @ApiOperation(value="\u666e\u901a\u6388\u4fe1\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByCreditCommonPageDto"})
    public Result<Page<CreditVo>> findByCreditCommonPageDto(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="CompanyInformationPageDto", value="\u5206\u9875Dto") CreditPageDto dto) {
        try {
            return Result.ok((Object)this.creditVoService.findByCreditCommonPageDto(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e34\u65f6\u6388\u4fe1\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByCreditTemporaryPageDto"})
    public Result<Page<CreditVo>> findByCreditTemporaryPageDto(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="CreditTemporaryPageDto", value="\u5206\u9875Dto") CreditTemporaryPageDto dto) {
        try {
            return Result.ok((Object)this.creditVoService.findByCreditTemporaryPageDto(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u666e\u901a\u6388\u4fe1ID\u83b7\u53d6\u6388\u4fe1\u4fe1\u606f")
    @GetMapping(value={"/findByCommonCreditId"})
    public Result<CreditVo> findByCommonCreditId(@RequestParam(value="commonCreditId", required=false) @ApiParam(name="commonCreditId", value="\u4e3b\u952eID") String commonCreditId) {
        try {
            return Result.ok((Object)this.creditVoService.findByCommonCreditId(commonCreditId));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u666e\u901a\u6388\u4fe1\u7f16\u7801\u83b7\u53d6\u6388\u4fe1\u4fe1\u606f")
    @GetMapping(value={"/findByCreditCode"})
    public Result<CreditVo> findByCreditCode(@RequestParam(value="creditCode", required=false) @ApiParam(name="creditCode", value="\u7f16\u7801") String creditCode) {
        try {
            return Result.ok((Object)this.creditVoService.findByCreditCode(creditCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e34\u65f6\u6388\u4fe1ID\u83b7\u53d6\u6388\u4fe1\u4fe1\u606f")
    @GetMapping(value={"/findByCreditTemporaryId"})
    public Result<CreditVo> findByCreditTemporaryId(@RequestParam(value="creditTemporaryId", required=false) @ApiParam(name="creditTemporaryId", value="\u4e3b\u952eID") String creditTemporaryId) {
        try {
            return Result.ok((Object)this.creditVoService.findByCreditTemporaryId(creditTemporaryId));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e34\u65f6\u6388\u4fe1\u7f16\u7801\u83b7\u53d6\u6388\u4fe1\u4fe1\u606f")
    @GetMapping(value={"/findByCreditTemporaryCode"})
    public Result<CreditVo> findByCreditTemporaryCode(@RequestParam(value="creditTemporaryCode", required=false) @ApiParam(name="creditTemporaryCode", value="\u6388\u4fe1\u7f16\u7801") String creditTemporaryCode) {
        try {
            return Result.ok((Object)this.creditVoService.findByCreditTemporaryCode(creditTemporaryCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5ba2\u6237-\u5546\u57ce\u6388\u4fe1\u5934\u5c55\u793a\u67e5\u8be2")
    @GetMapping(value={"/findByTotalCreditDto"})
    public Result<CreditVo> findByTotalCreditDto(@ApiParam(name="CreditDto", value="Dto") CreditDto dto) {
        try {
            return Result.ok((Object)this.creditVoService.findByTotalCreditDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5546\u57ce-\u5ba2\u6237\u4e34\u65f6\u6388\u4fe1\u7533\u8bf7\u8bb0\u5f55\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findApplyRecordByCreditTemporaryPageDto"})
    public Result<Page<CreditVo>> findApplyRecordByCreditTemporaryPageDto(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="CreditTemporaryPageDto", value="\u5206\u9875Dto") CreditTemporaryPageDto dto) {
        try {
            return Result.ok((Object)this.creditVoService.findApplyRecordByCreditTemporaryPageDto(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5546\u57ce-\u5ba2\u6237\u4e34\u65f6\u6388\u4fe1\u8bb0\u5f55\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findRecordByCreditTemporaryPageDto"})
    public Result<Page<CreditVo>> findRecordByCreditTemporaryPageDto(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="CreditTemporaryPageDto", value="\u5206\u9875Dto") CreditTemporaryPageDto dto) {
        try {
            return Result.ok((Object)this.creditVoService.findRecordByCreditTemporaryPageDto(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

