/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditWriteOffService;
import com.biz.crm.dms.business.costpool.credit.sdk.constant.CreditConstant;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTempWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditWriteOffVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWriteOffVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/credit/writeOff"})
@Api(tags={"\u6388\u4fe1\u7ba1\u7406: CreditWriteOffVo: \u6388\u4fe1\u6838\u9500\u4fe1\u606f"})
public class CreditWriteOffVoController {
    private static final Logger log = LoggerFactory.getLogger(CreditWriteOffVoController.class);
    @Autowired(required=false)
    private CreditWriteOffVoService creditWriteOffVoService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private CreditWriteOffService creditWriteOffService;
    @Autowired(required=false)
    private CreditVoService creditVoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u65b0\u589e\u6388\u4fe1\u6838\u9500")
    @PostMapping(value={""})
    public Result<?> create(@RequestBody CreditWriteOffDto dto) {
        String lockKey = this.creditVoService.buildCashLockKeyByCustomerCode(dto.getCustomerCode());
        Validate.isTrue((boolean)this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, CreditConstant.CREDIT_TRY_LOCK_OUT_TIME.intValue()), (String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u5173\u8054\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!", (Object[])new Object[0]);
        try {
            this.creditWriteOffService.create(dto);
            Result result = Result.ok();
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisMutexService.unlock(lockKey);
        }
    }

    @ApiOperation(value="\u666e\u901a\u6388\u4fe1\u6838\u9500\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @GetMapping(value={"findByConditions"})
    public Result<Page<CreditWriteOffVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="CreditWriteOffPageDto", value="\u5206\u9875Dto") CreditWriteOffPageDto dto) {
        try {
            return Result.ok((Object)this.creditWriteOffVoService.findByConditions(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e34\u65f6\u6388\u4fe1\u6838\u9500\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @GetMapping(value={"findByCreditTempWriteOffPageDto"})
    public Result<Page<CreditWriteOffVo>> findByCreditTempWriteOffPageDto(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="CreditTempWriteOffPageDto", value="\u5206\u9875Dto") CreditTempWriteOffPageDto dto) {
        try {
            return Result.ok((Object)this.creditWriteOffVoService.findByCreditTempWriteOffPageDto(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

