/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditCashModelDto;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashFlowService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.AbstractCreditCashFlowDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditType;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="creditCashFlowService")
public class CreditCashFlowServiceImpl
implements CreditCashFlowService {
    private static final Logger log = LoggerFactory.getLogger(CreditCashFlowServiceImpl.class);
    private Map<Class, CreditCashFlowRegister> registerMap = Maps.newHashMap();
    @Autowired(required=false)
    private CreditCashFlowRepository creditCashFlowRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CreditCashVoService creditCashVoService;

    public CreditCashFlowServiceImpl(List<CreditCashFlowRegister> itemRegisters) {
        if (CollectionUtils.isEmpty(itemRegisters)) {
            return;
        }
        itemRegisters.forEach(register -> {
            CreditCashFlowRegister itemRegister = this.registerMap.get(register.getClazz());
            Validate.isTrue((boolean)Objects.isNull(itemRegister), (String)String.format("\u5b58\u5728\u76f8\u540c\u7684\u6388\u4fe1\u8d44\u91d1\u6d41\u6c34\u6ce8\u518c\u5668[%s]", register.getClazz()), (Object[])new Object[0]);
            this.registerMap.put(register.getClazz(), (CreditCashFlowRegister)register);
        });
    }

    @Override
    @Transactional
    public CreditCashFlowEntity create(AbstractCreditCashFlowDto dto) {
        this.createValidation(dto);
        CreditCashFlowEntity entity = (CreditCashFlowEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CreditCashFlowEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setCashSerialNumber(UUID.randomUUID().toString());
        this.creditCashFlowRepository.save((Object)entity);
        dto.setId(entity.getId());
        CreditCashFlowRegister register = this.registerMap.get(dto.getClass());
        Validate.notNull((Object)register, (String)String.format("\u627e\u4e0d\u5230[%s]\u5bf9\u5e94\u7684\u6388\u4fe1\u8d44\u91d1\u6d41\u6c34\u62c6\u5206\u6ce8\u518c\u5668", dto.getClass()), (Object[])new Object[0]);
        List cashList = register.onCreate(dto);
        this.updateAmount(dto, cashList);
        return entity;
    }

    private void updateAmount(AbstractCreditCashFlowDto dto, List<CreditCashVo> cashList) {
        CreditCashModelDto modelDto = new CreditCashModelDto();
        modelDto.setCustomerCode(dto.getCustomerCode());
        Map<String, CreditCashVo> cashModelMap = this.creditCashVoService.findByCreditCashModelDto(modelDto);
        for (CreditCashVo creditCashVo : cashList) {
            cashModelMap.put(creditCashVo.getCreditId(), creditCashVo);
        }
        CreditCashVo normalCreditCashVo = null;
        for (CreditCashVo creditCashVo : cashModelMap.values()) {
            if (!CreditType.NORMAL_CREDIT.getDictCode().equals(creditCashVo.getCreditType())) continue;
            normalCreditCashVo = creditCashVo;
            break;
        }
        Validate.notNull(normalCreditCashVo, (String)"\u6388\u4fe1\u8d44\u91d1\u5f02\u5e38!", (Object[])new Object[0]);
        CreditCashFlowEntity creditCashFlowEntity = new CreditCashFlowEntity();
        creditCashFlowEntity.setId(dto.getId());
        creditCashFlowEntity.setLongAmount(normalCreditCashVo.getCreditAmount());
        creditCashFlowEntity.setLongCanUseAmount(normalCreditCashVo.getCanUseAmount());
        this.creditCashFlowRepository.updateById((Object)creditCashFlowEntity);
    }

    private void createValidation(AbstractCreditCashFlowDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getAdjustOperateCode(), (String)"\u7f3a\u5931\u8c03\u6574\u64cd\u4f5c\u7f16\u7801", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAdjustTypeCode(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b\u7f16\u7801", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAdjustOperateName(), (String)"\u7f3a\u5931\u8c03\u6574\u64cd\u4f5c\u540d\u79f0", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAdjustTypeName(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b\u540d\u79f0", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getOperateAmount(), (String)"\u7f3a\u5931\u64cd\u4f5c\u989d\u5ea6", (Object[])new Object[0]);
    }
}

