/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditDownUpAccountEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditFileModelDto;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditDownUpAccountRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashFlowService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditDownUpAccountService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditFileService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.AbstractCreditCashFlowDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDownUpAccountCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDownUpAccountDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditFileType;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditType;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="creditDownUpAccountService")
public class CreditDownUpAccountServiceImpl
implements CreditDownUpAccountService {
    private static final Logger log = LoggerFactory.getLogger(CreditDownUpAccountServiceImpl.class);
    @Autowired(required=false)
    private CreditDownUpAccountRepository creditDownUpAccountRepository;
    @Autowired(required=false)
    private CreditRepository creditRepository;
    @Autowired(required=false)
    private CreditCashFlowService creditCashFlowService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CreditFileService creditFileService;

    @Override
    @Transactional
    public void create(CreditDownUpAccountDto dto) {
        this.createValidation(dto);
        CashAdjustOperateEnum adjustOperate = CashAdjustOperateEnum.DOWN_UP_ACCOUNT;
        CashAdjustTypeEnum adjustType = CashAdjustTypeEnum.getByDictCode((String)dto.getOperateType());
        CreditDownUpAccountCashDto cashFlowDto = new CreditDownUpAccountCashDto();
        cashFlowDto.setCreditId(dto.getCreditId());
        cashFlowDto.setOperateAmount(dto.getDownUpAmount());
        cashFlowDto.setCustomerCode(dto.getCustomerCode());
        cashFlowDto.setAdjustOperateCode(adjustOperate.getDictCode());
        cashFlowDto.setAdjustOperateName(adjustOperate.getValue());
        cashFlowDto.setAdjustTypeCode(adjustType.getDictCode());
        cashFlowDto.setAdjustTypeName(adjustType.getValue());
        CreditCashFlowEntity cashFlowEntity = this.creditCashFlowService.create((AbstractCreditCashFlowDto)cashFlowDto);
        CreditDownUpAccountEntity entity = (CreditDownUpAccountEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CreditDownUpAccountEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setCashSerialNumber(cashFlowEntity.getCashSerialNumber());
        this.creditDownUpAccountRepository.save((Object)entity);
        CreditFileModelDto fileModelDto = new CreditFileModelDto();
        fileModelDto.setBusinessId(entity.getId());
        fileModelDto.setFileType(CreditFileType.DOWN_UP_ACCOUNT.getDictCode());
        fileModelDto.setFileList(dto.getFileList());
        this.creditFileService.update(Lists.newArrayList((Object[])new CreditFileModelDto[]{fileModelDto}));
    }

    private void createValidation(CreditDownUpAccountDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getCreditId(), (String)"\u7f3a\u5931\u6388\u4fe1ID\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOperateType(), (String)"\u7f3a\u5931\u64cd\u4f5c\u7c7b\u578b\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrderCode(), (String)"\u7f3a\u5931\u5355\u636e\u7f16\u7801\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrderType(), (String)"\u7f3a\u5931\u5355\u636e\u7c7b\u578b\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getDownUpAmount(), (String)"\u7f3a\u5931\u56de\u6b3e/\u4e0a\u8d26\u91d1\u989d!", (Object[])new Object[0]);
        Validate.isTrue((dto.getDownUpAmount().compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)"\u56de\u6b3e/\u4e0a\u8d26\u91d1\u989d\u4e0d\u80fd\u7b49\u4e8e0", (Object[])new Object[0]);
        ArrayList supportOperateTypes = Lists.newArrayList((Object[])new String[]{CashAdjustTypeEnum.OTHER.getDictCode(), CashAdjustTypeEnum.CUSTOMER_UP_ACCOUNT.getDictCode(), CashAdjustTypeEnum.WRITE_OFF_UP_ACCOUNT.getDictCode()});
        Validate.isTrue((boolean)supportOperateTypes.contains(dto.getOperateType()), (String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b\uff01", (Object[])new Object[0]);
        CreditEntity creditEntity = (CreditEntity)((Object)this.creditRepository.getById((Serializable)((Object)dto.getCreditId())));
        Validate.notNull((Object)((Object)creditEntity), (String)"\u6388\u4fe1\u4fe1\u606f\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((boolean)creditEntity.getCreditType().equals(CreditType.NORMAL_CREDIT.getDictCode()), (String)"\u56de\u6b3e\u4e0a\u8d26\u53ea\u652f\u6301\u666e\u901a\u6388\u4fe1", (Object[])new Object[0]);
        dto.setCustomerCode(creditEntity.getCustomerCode());
        Date nowDate = new Date();
        Validate.isTrue((creditEntity.getCreditEndTime().getTime() >= nowDate.getTime() ? 1 : 0) != 0, (String)"\u666e\u901a\u6388\u4fe1\u5df2\u8fc7\u671f,\u65e0\u6cd5\u56de\u6b3e\u4e0a\u8d26", (Object[])new Object[0]);
    }
}

