/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditFreezeEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditCashModelDto;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditFreezeRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashFlowService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashVoService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditFreezeService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.AbstractCreditCashFlowDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditFreezeCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditFreezeDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditType;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="creditFreezeService")
public class CreditFreezeServiceImpl
implements CreditFreezeService {
    private static final Logger log = LoggerFactory.getLogger(CreditFreezeServiceImpl.class);
    @Autowired(required=false)
    private CreditFreezeRepository creditFreezeRepository;
    @Autowired(required=false)
    private CreditCashVoService creditCashVoService;
    @Autowired(required=false)
    private CreditRepository creditRepository;
    @Autowired(required=false)
    private CreditCashFlowService creditCashFlowService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void create(CreditFreezeDto dto) {
        this.createValidation(dto);
        CashAdjustOperateEnum adjustOperate = CashAdjustOperateEnum.FREEZE_UNFREEZE;
        CashAdjustTypeEnum adjustType = CashAdjustTypeEnum.FREEZE_UNFREEZE;
        CreditFreezeCashDto cashFlowDto = new CreditFreezeCashDto();
        cashFlowDto.setCreditId(dto.getCreditId());
        cashFlowDto.setOperateAmount(BigDecimal.ZERO.subtract(dto.getFreezeAmount()));
        cashFlowDto.setCustomerCode(dto.getCustomerCode());
        cashFlowDto.setAdjustOperateCode(adjustOperate.getDictCode());
        cashFlowDto.setAdjustOperateName(adjustOperate.getValue());
        cashFlowDto.setAdjustTypeCode(adjustType.getDictCode());
        cashFlowDto.setAdjustTypeName(adjustType.getValue());
        CreditCashFlowEntity cashFlowEntity = this.creditCashFlowService.create((AbstractCreditCashFlowDto)cashFlowDto);
        CreditFreezeEntity entity = (CreditFreezeEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CreditFreezeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setCashSerialNumber(cashFlowEntity.getCashSerialNumber());
        this.creditFreezeRepository.save((Object)entity);
    }

    private void createValidation(CreditFreezeDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getCreditId(), (String)"\u7f3a\u5931\u6388\u4fe1ID\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCreditType(), (String)"\u7f3a\u5931\u6388\u4fe1\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getFreezeFlag(), (String)"\u7f3a\u5931\u51bb\u7ed3\u6807\u5fd7!", (Object[])new Object[0]);
        CreditEntity creditEntity = (CreditEntity)((Object)this.creditRepository.getById((Serializable)((Object)dto.getCreditId())));
        Validate.notNull((Object)((Object)creditEntity), (String)"\u6388\u4fe1\u4fe1\u606f\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((boolean)creditEntity.getCreditType().equals(dto.getCreditType()), (String)"\u6388\u4fe1\u7c7b\u578b\u4e0d\u5339\u914d", (Object[])new Object[0]);
        if (CreditType.TEMPORARY_CREDIT.getDictCode().equals(creditEntity.getCreditType())) {
            Validate.isTrue((boolean)ProcessStatusEnum.PASS.getDictCode().equals(creditEntity.getProcessStatus()), (String)"\u4e34\u65f6\u6388\u4fe1\u672a\u5ba1\u6279\u901a\u8fc7,\u65e0\u6cd5\u51bb\u7ed3/\u89e3\u51bb", (Object[])new Object[0]);
        }
        Date nowDate = new Date();
        Validate.isTrue((creditEntity.getCreditStartTime().before(nowDate) && creditEntity.getCreditEndTime().after(nowDate) ? 1 : 0) != 0, (String)"\u6388\u4fe1\u4e0d\u5728\u6709\u6548\u671f\u5185,\u65e0\u6cd5\u51bb\u7ed3/\u89e3\u51bb", (Object[])new Object[0]);
        dto.setCustomerCode(creditEntity.getCustomerCode());
        CreditCashModelDto modelDto = new CreditCashModelDto();
        modelDto.setCreditIdList(Lists.newArrayList((Object[])new String[]{dto.getCreditId()}));
        Map<String, CreditCashVo> cashModelMap = this.creditCashVoService.findByCreditCashModelDto(modelDto);
        CreditCashVo modelVo = cashModelMap.get(dto.getCreditId());
        Validate.notNull((Object)modelVo, (String)"\u65e0\u53ef\u64cd\u4f5c\u6388\u4fe1\u989d\u5ea6!", (Object[])new Object[0]);
        if (CreditType.NORMAL_CREDIT.getDictCode().equals(dto.getCreditType())) {
            Validate.notNull((Object)dto.getFreezeAmount(), (String)"\u7f3a\u5931\u51bb\u7ed3\u989d\u5ea6", (Object[])new Object[0]);
            Validate.isTrue((dto.getFreezeAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u989d\u5ea6\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
            Validate.isTrue((dto.getFreezeAmount().compareTo(creditEntity.getCreditAmount()) <= 0 ? 1 : 0) != 0, (String)"\u51bb\u7ed3\u989d\u5ea6\u5fc5\u987b\u5c0f\u4e8e\u6388\u4fe1\u91d1\u989d", (Object[])new Object[0]);
            dto.setFreezeAmount(dto.getFreezeAmount().subtract(modelVo.getFreezeAmount()));
        } else if (Boolean.TRUE.equals(dto.getFreezeFlag())) {
            Validate.isTrue((modelVo.getFreezeAmount().compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u6388\u4fe1\u4fe1\u606f\u5df2\u51bb\u7ed3,\u65e0\u6cd5\u7ee7\u7eed\u51bb\u7ed3!", (Object[])new Object[0]);
            dto.setFreezeAmount(creditEntity.getCreditAmount());
        } else {
            Validate.isTrue((modelVo.getFreezeAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6388\u4fe1\u4fe1\u606f\u5df2\u89e3\u51bb,\u65e0\u6cd5\u7ee7\u7eed\u89e3\u51bb!", (Object[])new Object[0]);
            dto.setFreezeAmount(BigDecimal.ZERO.subtract(modelVo.getFreezeAmount()));
        }
    }
}

