/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditOccupyEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditOccupyRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashFlowService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditOccupyService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.AbstractCreditCashFlowDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditOccupyCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditOccupyDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditOrderTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.OccupyTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreditOccupyServiceImpl
implements CreditOccupyService {
    private static final Logger log = LoggerFactory.getLogger(CreditOccupyServiceImpl.class);
    @Autowired(required=false)
    private CreditOccupyRepository creditOccupyRepository;
    @Autowired(required=false)
    private CreditCashFlowService creditCashFlowService;

    @Override
    @Transactional
    public void occupy(CreditOccupyDto dto) {
        this.createValidation(dto);
        Validate.isTrue((boolean)CashAdjustTypeEnum.OCCUPY_USE.getDictCode().equals(dto.getAdjustTypeCode()), (String)"\u4e0d\u652f\u6301\u7684\u6388\u4fe1\u8c03\u6574\u7c7b\u578b\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)CashAdjustOperateEnum.OCCUPY_USE.getDictCode().equals(dto.getAdjustOperateCode()), (String)"\u4e0d\u652f\u6301\u7684\u6388\u4fe1\u8c03\u6574\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        CashAdjustOperateEnum adjustOperate = CashAdjustOperateEnum.getByDictCode((String)dto.getAdjustOperateCode());
        CashAdjustTypeEnum adjustType = CashAdjustTypeEnum.getByDictCode((String)dto.getAdjustTypeCode());
        CreditOccupyEntity entity = new CreditOccupyEntity();
        entity.setBusinessOrderCode(dto.getFromCode());
        entity.setOccupyAmount(BigDecimal.ZERO.subtract(dto.getAmount()));
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setOrderType(CreditOrderTypeEnum.SALE_ORDER.getDictCode());
        entity.setOccupyType(OccupyTypeEnum.OCCUPY.getDictCode());
        CreditOccupyCashDto cashFlowDto = new CreditOccupyCashDto();
        cashFlowDto.setOperateAmount(BigDecimal.ZERO.subtract(dto.getAmount()));
        cashFlowDto.setCustomerCode(dto.getCustomerCode());
        cashFlowDto.setBusinessOrderCode(dto.getFromCode());
        cashFlowDto.setAdjustOperateCode(adjustOperate.getDictCode());
        cashFlowDto.setAdjustOperateName(adjustOperate.getValue());
        cashFlowDto.setAdjustTypeCode(adjustType.getDictCode());
        cashFlowDto.setAdjustTypeName(adjustType.getValue());
        cashFlowDto.setOccupyType(OccupyTypeEnum.OCCUPY.getDictCode());
        CreditCashFlowEntity cashFlowEntity = this.creditCashFlowService.create((AbstractCreditCashFlowDto)cashFlowDto);
        entity.setCashSerialNumber(cashFlowEntity.getCashSerialNumber());
        this.creditOccupyRepository.save((Object)entity);
    }

    @Override
    @Transactional
    public void release(CreditOccupyDto dto) {
        this.createValidation(dto);
        Validate.isTrue((boolean)CashAdjustTypeEnum.OCCUPY_RELEASE.getDictCode().equals(dto.getAdjustTypeCode()), (String)"\u4e0d\u652f\u6301\u7684\u6388\u4fe1\u8c03\u6574\u7c7b\u578b\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)CashAdjustOperateEnum.OCCUPY_RELEASE.getDictCode().equals(dto.getAdjustOperateCode()), (String)"\u4e0d\u652f\u6301\u7684\u6388\u4fe1\u8c03\u6574\u64cd\u4f5c\uff01", (Object[])new Object[0]);
        CashAdjustOperateEnum adjustOperate = CashAdjustOperateEnum.getByDictCode((String)dto.getAdjustOperateCode());
        CashAdjustTypeEnum adjustType = CashAdjustTypeEnum.getByDictCode((String)dto.getAdjustTypeCode());
        CreditOccupyEntity entity = new CreditOccupyEntity();
        entity.setBusinessOrderCode(dto.getFromCode());
        entity.setOccupyAmount(dto.getAmount());
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setOrderType(CreditOrderTypeEnum.SALE_ORDER.getDictCode());
        entity.setOccupyType(OccupyTypeEnum.RELEASE.getDictCode());
        CreditOccupyCashDto cashFlowDto = new CreditOccupyCashDto();
        cashFlowDto.setOperateAmount(dto.getAmount());
        cashFlowDto.setCustomerCode(dto.getCustomerCode());
        cashFlowDto.setBusinessOrderCode(dto.getFromCode());
        cashFlowDto.setAdjustOperateCode(adjustOperate.getDictCode());
        cashFlowDto.setAdjustOperateName(adjustOperate.getValue());
        cashFlowDto.setAdjustTypeCode(adjustType.getDictCode());
        cashFlowDto.setAdjustTypeName(adjustType.getValue());
        cashFlowDto.setOccupyType(OccupyTypeEnum.RELEASE.getDictCode());
        CreditCashFlowEntity cashFlowEntity = this.creditCashFlowService.create((AbstractCreditCashFlowDto)cashFlowDto);
        entity.setCashSerialNumber(cashFlowEntity.getCashSerialNumber());
        this.creditOccupyRepository.save((Object)entity);
    }

    private void createValidation(CreditOccupyDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAdjustOperateCode(), (String)"\u7f3a\u5931\u8c03\u6574\u64cd\u4f5c\u7f16\u7801\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAdjustTypeCode(), (String)"\u7f3a\u5931\u8c03\u6574\u7c7b\u578b\u7f16\u7801\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFromCode(), (String)"\u7f3a\u5931\u6765\u6e90\u7f16\u7801!", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getAmount(), (String)"\u7f3a\u5931\u91d1\u989d!", (Object[])new Object[0]);
        Validate.isTrue((dto.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
    }
}

