/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditFileModelDto;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditWriteOffVoRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditFileService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditFileDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditRepayNoticeDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditFileType;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditType;
import com.biz.crm.dms.business.costpool.credit.sdk.event.CreditEventListener;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditEventVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditFileVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWriteOffVo;
import com.biz.crm.dms.business.interaction.sdk.dto.base.ScopeDto;
import com.biz.crm.dms.business.interaction.sdk.dto.notice.NoticeDto;
import com.biz.crm.dms.business.interaction.sdk.enums.NoticePopupType;
import com.biz.crm.dms.business.interaction.sdk.enums.ScopeType;
import com.biz.crm.dms.business.interaction.sdk.service.notice.NoticeVoService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="creditService")
public class CreditServiceImpl
implements CreditService {
    private static final Logger log = LoggerFactory.getLogger(CreditServiceImpl.class);
    @Autowired(required=false)
    private CreditRepository creditRepository;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CreditFileService creditFileService;
    @Autowired(required=false)
    private List<CreditEventListener> listeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CreditWriteOffVoRepository creditWriteOffVoRepository;
    @Autowired(required=false)
    private NoticeVoService noticeVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Value(value="${crm.business.credit.process-key:}")
    private String defaultProcessKey;

    @Override
    @Transactional
    public void create(CreditDto dto) {
        this.createValidation(dto);
        Map<String, CustomerVo> customerMap = this.buildCustomerMap(dto.getCustomerCodeList());
        List<CreditEntity> entities = dto.getCustomerCodeList().stream().map(customerCode -> {
            CustomerVo customerVo = (CustomerVo)customerMap.get(customerCode);
            Validate.notNull((Object)customerVo, (String)String.format("\u5ba2\u6237[%s]\u4fe1\u606f\u4e0d\u5b58\u5728!", customerCode), (Object[])new Object[0]);
            CreditEntity creditEntity = (CreditEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CreditEntity.class, HashSet.class, ArrayList.class, new String[0])));
            creditEntity.setCustomerCode((String)customerCode);
            creditEntity.setCustomerName(customerVo.getCustomerName());
            creditEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            creditEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            creditEntity.setCreditCode((String)this.generateCodeService.generateCode("SX", 1).get(0));
            creditEntity.setProcessStatus(CreditType.TEMPORARY_CREDIT.getDictCode().equals(creditEntity.getCreditType()) ? ProcessStatusEnum.PREPARE.getDictCode() : ProcessStatusEnum.PASS.getDictCode());
            this.creditRepository.save((Object)creditEntity);
            if (CreditType.TEMPORARY_CREDIT.getDictCode().equals(creditEntity.getCreditType()) && Boolean.TRUE.equals(dto.getSubmitProcess())) {
                dto.setCreditCode(creditEntity.getCreditCode());
                dto.setId(creditEntity.getId());
                creditEntity.setProcessNumber(this.commitProcess(dto));
                creditEntity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
                this.creditRepository.updateById((Object)creditEntity);
            }
            return creditEntity;
        }).collect(Collectors.toList());
        this.createExtInfo(dto, entities);
    }

    @Override
    @Transactional
    public void update(CreditDto dto) {
        this.updateValidation(dto);
        CreditEntity creditEntity = (CreditEntity)((Object)this.creditRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)creditEntity), (String)"\u6388\u4fe1\u4fe1\u606f\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        CreditEntity updateEntity = (CreditEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CreditEntity.class, HashSet.class, ArrayList.class, new String[0]));
        updateEntity.setProcessStatus(creditEntity.getProcessStatus());
        this.creditRepository.updateById((Object)updateEntity);
        CreditFileModelDto fileModelDto = new CreditFileModelDto();
        fileModelDto.setBusinessId(creditEntity.getId());
        fileModelDto.setFileType(CreditFileType.CREDIT.getDictCode());
        fileModelDto.setFileList(dto.getFileList());
        this.creditFileService.update(Lists.newArrayList((Object[])new CreditFileModelDto[]{fileModelDto}));
        if (CreditType.TEMPORARY_CREDIT.getDictCode().equals(creditEntity.getCreditType()) && Boolean.TRUE.equals(dto.getSubmitProcess())) {
            dto.setId(creditEntity.getId());
            dto.setCreditCode(creditEntity.getCreditCode());
            updateEntity.setProcessNumber(this.commitProcess(dto));
            updateEntity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            this.creditRepository.updateById((Object)updateEntity);
        }
        if (!CollectionUtils.isEmpty(this.listeners)) {
            CreditEventVo oldVo = (CreditEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)creditEntity, CreditEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            CreditEventVo newVo = (CreditEventVo)this.nebulaToolkitService.copyObjectByBlankList((Object)updateEntity, CreditEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            newVo.setCustomerCode(oldVo.getCustomerCode());
            this.listeners.forEach(listener -> listener.onUpdate(oldVo, newVo));
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> customerCodes) {
        Validate.isTrue((!CollectionUtils.isEmpty(customerCodes) ? 1 : 0) != 0, (String)"\u6388\u4fe1\u5ba2\u6237\u7f16\u7801\u96c6\u5408", (Object[])new Object[0]);
        List<CreditEntity> entities = this.creditRepository.findByCustomerCodes(customerCodes, null, EnableStatusEnum.DISABLE.getCode(), TenantUtils.getTenantCode());
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u65e0\u53ef\u542f\u7528\u6388\u4fe1\u4fe1\u606f", (Object[])new Object[0]);
        List<String> ids = entities.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.creditRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, CreditEntity.class, CreditEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onEnable(voList));
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> customerCodes) {
        Validate.isTrue((!CollectionUtils.isEmpty(customerCodes) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u6388\u4fe1\u5ba2\u6237\u7f16\u7801\u96c6\u5408", (Object[])new Object[0]);
        List<CreditEntity> entities = this.creditRepository.findByCustomerCodes(customerCodes, null, EnableStatusEnum.ENABLE.getCode(), TenantUtils.getTenantCode());
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u65e0\u53ef\u7981\u7528\u6388\u4fe1\u4fe1\u606f", (Object[])new Object[0]);
        List<String> ids = entities.stream().map(UuidEntity::getId).collect(Collectors.toList());
        this.creditRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, CreditEntity.class, CreditEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onDisable(voList));
        }
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u6388\u4fe1id", (Object[])new Object[0]);
        List entities = this.creditRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(ids) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        entities.forEach(creditEntity -> {
            Validate.isTrue((boolean)CreditType.TEMPORARY_CREDIT.getDictCode().equals(creditEntity.getCreditType()), (String)String.format("\u5f53\u524d\u6388\u4fe1[%s],\u975e\u4e34\u65f6\u6388\u4fe1\u65e0\u6cd5\u5220\u9664", creditEntity.getCreditCode()), (Object[])new Object[0]);
            Validate.isTrue((boolean)ProcessStatusEnum.PREPARE.getDictCode().equals(creditEntity.getProcessStatus()), (String)String.format("\u5f53\u524d\u4e34\u65f6\u6388\u4fe1[%s],\u975e\u5f85\u63d0\u4ea4\u72b6\u6001\u65e0\u6cd5\u5220\u9664", creditEntity.getCreditCode()), (Object[])new Object[0]);
        });
        this.creditRepository.updateDelFlagByIds(ids);
    }

    @Override
    public void sendNotice(CreditRepayNoticeDto dto) {
        Validate.notNull((Object)dto, (String)"\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<CreditWriteOffVo> creditWriteOffList = this.creditWriteOffVoRepository.findByCreditRepayNoticeDto(dto);
        Validate.isTrue((!CollectionUtils.isEmpty(creditWriteOffList) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u9700\u8981\u8fd8\u6b3e\u7684\u5ba2\u6237", (Object[])new Object[0]);
        List noticeDtoList = creditWriteOffList.stream().map(creditWriteOffVo -> {
            NoticeDto noticeDto = (NoticeDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, NoticeDto.class, HashSet.class, ArrayList.class, new String[0]);
            noticeDto.setContent(String.format("\u5c0a\u656c\u7684\u5ba2\u6237,\u76ee\u524d\u60a8\u7684\u8d26\u6237\u4fe1\u7528\u5f85\u8fd8\u6b3e\u91d1\u989d%s\u5143\u3002\u8bf7\u53ca\u65f6\u5b8c\u6210\u56de\u6b3e\uff0c\u907f\u514d\u9020\u6210\u5bf9\u60a8\u4fe1\u7528\u5206\u503c\u5f71\u54cd\u3002", creditWriteOffVo.getWaitWriteOffAmount()));
            if (Boolean.TRUE.equals(dto.getIndexPopup())) {
                noticeDto.setPopupType(NoticePopupType.READ_NOT_POPUP.getDictCode());
            }
            ScopeDto scopeDto = new ScopeDto();
            scopeDto.setContainFlag(Boolean.TRUE);
            scopeDto.setScopeCode(creditWriteOffVo.getCustomerCode());
            scopeDto.setScopeType(ScopeType.CUSTOMER.name());
            noticeDto.setScopeList((List)Lists.newArrayList((Object[])new ScopeDto[]{scopeDto}));
            return noticeDto;
        }).collect(Collectors.toList());
        this.noticeVoService.create(noticeDtoList);
    }

    private void createExtInfo(CreditDto dto, List<CreditEntity> entities) {
        ArrayList fileModelDtoList = Lists.newArrayList();
        ArrayList eventVoList = Lists.newArrayList();
        entities.forEach(creditEntity -> {
            CreditFileModelDto fileModelDto = new CreditFileModelDto();
            fileModelDto.setBusinessId(creditEntity.getId());
            fileModelDto.setFileType(CreditFileType.CREDIT.getDictCode());
            fileModelDto.setFileList(dto.getFileList());
            fileModelDtoList.add(fileModelDto);
            CreditEventVo creditEventVo = (CreditEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)creditEntity, CreditEventVo.class, HashSet.class, ArrayList.class, new String[0]);
            if (!CollectionUtils.isEmpty((Collection)dto.getFileList())) {
                List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getFileList(), CreditFileDto.class, CreditFileVo.class, HashSet.class, ArrayList.class, new String[0]);
                creditEventVo.setFileList(list);
            }
            eventVoList.add(creditEventVo);
        });
        this.creditFileService.update(fileModelDtoList);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            this.listeners.forEach(listener -> listener.onCreate(eventVoList));
        }
    }

    private Map<String, CustomerVo> buildCustomerMap(List<String> customerCodes) {
        HashMap resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(customerCodes)) {
            return resultMap;
        }
        List customerList = this.customerVoService.findByCustomerCodes(customerCodes);
        if (CollectionUtils.isEmpty((Collection)customerList)) {
            return resultMap;
        }
        return customerList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, t -> t, (key1, key2) -> key2));
    }

    private void createValidation(CreditDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getCustomerCodeList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCreditType(), (String)"\u7f3a\u5931\u6388\u4fe1\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCreditStartTime(), (String)"\u7f3a\u5931\u6388\u4fe1\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCreditEndTime(), (String)"\u7f3a\u5931\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getRepayEndTime(), (String)"\u7f3a\u5931\u8fd8\u6b3e\u622a\u6b62\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((boolean)dto.getCreditStartTime().before(dto.getCreditEndTime()), (String)"\u6388\u4fe1\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((dto.getCreditEndTime().getTime() <= dto.getRepayEndTime().getTime() ? 1 : 0) != 0, (String)"\u6388\u4fe1\u8fd8\u6b3e\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCreditAmount(), (String)"\u7f3a\u5931\u6388\u4fe1\u989d\u5ea6", (Object[])new Object[0]);
        Validate.isTrue((dto.getCreditAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6388\u4fe1\u989d\u5ea6\u9700\u5927\u4e8e0", (Object[])new Object[0]);
        List scopeTypeList = Arrays.stream(CreditType.values()).map(CreditType::getDictCode).collect(Collectors.toList());
        Validate.isTrue((boolean)scopeTypeList.contains(dto.getCreditType()), (String)"\u4e0d\u652f\u6301\u7684\u6388\u4fe1\u7c7b\u578b!", (Object[])new Object[0]);
        List<CreditEntity> creditEntities = this.creditRepository.findByCustomerCodes(dto.getCustomerCodeList(), CreditType.NORMAL_CREDIT.getDictCode(), null, dto.getTenantCode());
        if (CreditType.NORMAL_CREDIT.getDictCode().equals(dto.getCreditType())) {
            Validate.isTrue((boolean)CollectionUtils.isEmpty(creditEntities), (String)String.format("\u5ba2\u6237[%s]\u5df2\u5f00\u901a\u6388\u4fe1,\u65e0\u6cd5\u7ee7\u7eed\u5f00\u901a!", CollectionUtils.isEmpty(creditEntities) ? "" : creditEntities.get(0).getCustomerName()), (Object[])new Object[0]);
        } else {
            Map<String, CreditEntity> entityMap = creditEntities.stream().collect(Collectors.toMap(CreditEntity::getCustomerCode, t -> t));
            Date nowDate = new Date();
            dto.getCustomerCodeList().forEach(customerCode -> {
                CreditEntity creditEntity = (CreditEntity)((Object)((Object)entityMap.get(customerCode)));
                Validate.notNull((Object)((Object)creditEntity), (String)String.format("\u5ba2\u6237[%s]\u672a\u5f00\u901a\u666e\u901a\u6388\u4fe1,\u8bf7\u5148\u5f00\u901a\u666e\u901a\u6388\u4fe1", customerCode), (Object[])new Object[0]);
                Validate.isTrue((creditEntity.getCreditStartTime().getTime() <= dto.getCreditStartTime().getTime() ? 1 : 0) != 0, (String)"\u4e34\u65f6\u6388\u4fe1\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u666e\u901a\u6388\u4fe1\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
                Validate.isTrue((creditEntity.getCreditEndTime().getTime() >= dto.getCreditEndTime().getTime() ? 1 : 0) != 0, (String)"\u4e34\u65f6\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u666e\u901a\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
                Validate.isTrue((creditEntity.getRepayEndTime().getTime() >= dto.getRepayEndTime().getTime() ? 1 : 0) != 0, (String)"\u4e34\u65f6\u6388\u4fe1\u8fd8\u6b3e\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u666e\u901a\u6388\u4fe1\u8fd8\u6b3e\u65f6\u95f4", (Object[])new Object[0]);
                Validate.isTrue((creditEntity.getCreditEndTime().getTime() >= nowDate.getTime() ? 1 : 0) != 0, (String)"\u666e\u901a\u6388\u4fe1\u5df2\u8fc7\u671f,\u65e0\u6cd5\u5f00\u901a\u4e34\u65f6\u6388\u4fe1", (Object[])new Object[0]);
            });
        }
    }

    private void updateValidation(CreditDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCreditType(), (String)"\u7f3a\u5931\u6388\u4fe1\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCreditStartTime(), (String)"\u7f3a\u5931\u6388\u4fe1\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCreditEndTime(), (String)"\u7f3a\u5931\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getRepayEndTime(), (String)"\u7f3a\u5931\u8fd8\u6b3e\u622a\u6b62\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((boolean)dto.getCreditStartTime().before(dto.getCreditEndTime()), (String)"\u6388\u4fe1\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((dto.getCreditEndTime().getTime() <= dto.getRepayEndTime().getTime() ? 1 : 0) != 0, (String)"\u6388\u4fe1\u8fd8\u6b3e\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getCreditAmount(), (String)"\u7f3a\u5931\u6388\u4fe1\u989d\u5ea6", (Object[])new Object[0]);
        Validate.isTrue((dto.getCreditAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6388\u4fe1\u989d\u5ea6\u9700\u5927\u4e8e0", (Object[])new Object[0]);
        if (CreditType.NORMAL_CREDIT.getDictCode().equals(dto.getCreditType())) {
            List<CreditEntity> temporaryCreditEntities = this.creditRepository.findByCustomerCodes(Lists.newArrayList((Object[])new String[]{dto.getCustomerCode()}), CreditType.TEMPORARY_CREDIT.getDictCode(), null, dto.getTenantCode());
            if (!CollectionUtils.isEmpty(temporaryCreditEntities)) {
                temporaryCreditEntities.forEach(creditEntity -> {
                    Validate.isTrue((dto.getCreditStartTime().getTime() <= creditEntity.getCreditStartTime().getTime() ? 1 : 0) != 0, (String)"\u5b58\u5728\u4e34\u65f6\u6388\u4fe1\u5f00\u59cb\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u666e\u901a\u6388\u4fe1\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
                    Validate.isTrue((dto.getCreditEndTime().getTime() >= creditEntity.getCreditEndTime().getTime() ? 1 : 0) != 0, (String)"\u5b58\u5728\u4e34\u65f6\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4\u5927\u4e8e\u5f53\u524d\u666e\u901a\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
                    Validate.isTrue((dto.getCreditEndTime().getTime() >= creditEntity.getCreditEndTime().getTime() ? 1 : 0) != 0, (String)"\u5b58\u5728\u4e34\u65f6\u6388\u4fe1\u8fd8\u6b3e\u65f6\u95f4\u5927\u4e8e\u5f53\u524d\u666e\u901a\u6388\u4fe1\u8fd8\u6b3e\u65f6\u95f4", (Object[])new Object[0]);
                });
            }
        } else {
            List<CreditEntity> normalCreditEntities = this.creditRepository.findByCustomerCodes(Lists.newArrayList((Object[])new String[]{dto.getCustomerCode()}), CreditType.NORMAL_CREDIT.getDictCode(), null, dto.getTenantCode());
            Validate.isTrue((!CollectionUtils.isEmpty(normalCreditEntities) && normalCreditEntities.size() == 1 ? 1 : 0) != 0, (String)"\u4e34\u65f6\u6388\u4fe1\u5bf9\u5e94\u7684\u666e\u901a\u6388\u4fe1\u5f02\u5e38", (Object[])new Object[0]);
            CreditEntity creditEntity2 = normalCreditEntities.get(0);
            Validate.isTrue((creditEntity2.getCreditStartTime().getTime() <= dto.getCreditStartTime().getTime() ? 1 : 0) != 0, (String)"\u4e34\u65f6\u6388\u4fe1\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u666e\u901a\u6388\u4fe1\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
            Validate.isTrue((creditEntity2.getCreditEndTime().getTime() >= dto.getCreditEndTime().getTime() ? 1 : 0) != 0, (String)"\u4e34\u65f6\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u666e\u901a\u6388\u4fe1\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
            Validate.isTrue((creditEntity2.getRepayEndTime().getTime() >= dto.getRepayEndTime().getTime() ? 1 : 0) != 0, (String)"\u4e34\u65f6\u6388\u4fe1\u8fd8\u6b3e\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u666e\u901a\u6388\u4fe1\u8fd8\u6b3e\u65f6\u95f4", (Object[])new Object[0]);
        }
    }

    private String commitProcess(CreditDto dto) {
        ProcessBusinessDto businessProcessDto = dto.getProcessBusiness();
        businessProcessDto.setBusinessNo(dto.getCreditCode());
        businessProcessDto.setBusinessFormJson(JsonUtils.obj2JsonString((Object)dto));
        businessProcessDto.setBusinessCode("credit");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(businessProcessDto);
        return processBusinessVo.getProcessNo();
    }

    @Override
    @Transactional
    public void handleTemporaryCreditApply(CreditDto dto) {
        String customerCode = dto.getCustomerCode();
        String customerName = dto.getCustomerName();
        if (StringUtils.isBlank((CharSequence)customerCode)) {
            return;
        }
        ArrayList customerList = Lists.newArrayList();
        customerList.add(customerCode);
        dto.setCustomerCodeList((List)customerList);
        dto.setCreditType(CreditType.TEMPORARY_CREDIT.getDictCode());
        this.createValidation(dto);
        CreditEntity creditEntity = (CreditEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CreditEntity.class, HashSet.class, ArrayList.class, new String[0]));
        creditEntity.setCustomerCode(customerCode);
        creditEntity.setCustomerName(customerName);
        creditEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        creditEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        creditEntity.setCreditCode((String)this.generateCodeService.generateCode("SX", 1).get(0));
        creditEntity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        this.creditRepository.save((Object)creditEntity);
        ArrayList entities = Lists.newArrayList();
        entities.add(creditEntity);
        this.createExtInfo(dto, entities);
        dto.setId(creditEntity.getId());
        dto.setCreditCode(creditEntity.getCreditCode());
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        processBusiness.setProcessKey(this.defaultProcessKey);
        processBusiness.setProcessTitle(customerName + "\u5546\u57ce\u53d1\u8d77\u4e34\u65f6\u6388\u4fe1\u5ba1\u6279\u6d41\u7a0b");
        creditEntity.setProcessNumber(this.commitProcess(dto));
        this.creditRepository.updateById((Object)creditEntity);
    }
}

