/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditWriteOffEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditWriteOffRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditWriteOffVoRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditTempWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffPageDto;
import com.biz.crm.dms.business.costpool.credit.sdk.service.CreditWriteOffVoService;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditWriteOffVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CreditWriteOffVoServiceImpl
implements CreditWriteOffVoService {
    @Autowired(required=false)
    private CreditWriteOffVoRepository creditWriteOffVoRepository;
    @Autowired(required=false)
    private CreditWriteOffRepository creditWriteOffRepository;

    public Page<CreditWriteOffVo> findByConditions(Pageable pageable, CreditWriteOffPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CreditWriteOffPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CreditWriteOffPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<CreditWriteOffVo> page = this.creditWriteOffVoRepository.findByConditions(pageable, dto);
        this.perfectCreditWriteOffInfo(page.getRecords());
        return page;
    }

    public Page<CreditWriteOffVo> findByCreditTempWriteOffPageDto(Pageable pageable, CreditTempWriteOffPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (CreditTempWriteOffPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CreditTempWriteOffPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isBlank((CharSequence)dto.getCustomerCode())) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize(), 0L);
        }
        Page<CreditWriteOffVo> page = this.creditWriteOffVoRepository.findByCreditTempWriteOffPageDto(pageable, dto);
        this.perfectCreditWriteOffInfo(page.getRecords());
        return page;
    }

    private void perfectCreditWriteOffInfo(List<CreditWriteOffVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<String> customerCodes = list.stream().map(CreditWriteOffVo::getCustomerCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customerCodes)) {
            return;
        }
        List<CreditWriteOffEntity> writeOffEntities = this.creditWriteOffRepository.findByCustomerCodes(TenantUtils.getTenantCode(), customerCodes);
        if (CollectionUtils.isEmpty(writeOffEntities)) {
            return;
        }
        Map<String, CreditWriteOffEntity> writeOffEntityMap = writeOffEntities.stream().collect(Collectors.toMap(CreditWriteOffEntity::getCustomerCode, t -> t, (a, b) -> a));
        list.forEach(creditWriteOffVo -> {
            CreditWriteOffEntity writeOffEntity = writeOffEntityMap.getOrDefault(creditWriteOffVo.getCustomerCode(), new CreditWriteOffEntity());
            creditWriteOffVo.setRecentlyWriteOffTime(writeOffEntity.getCreateTime());
        });
    }
}

