/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.notifier;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditRecordEntity;
import com.biz.crm.dms.business.costpool.credit.local.model.CreditFileModelDto;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRecordRepository;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditCashFlowService;
import com.biz.crm.dms.business.costpool.credit.local.service.CreditFileService;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.AbstractCreditCashFlowDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCreateCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditFileDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditUpdateCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustOperateEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CashAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditFileType;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditType;
import com.biz.crm.dms.business.costpool.credit.sdk.event.CreditEventListener;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditEventVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditFileVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class CreditRecordEventListenerImpl
implements CreditEventListener {
    @Autowired(required=false)
    private CreditRecordRepository creditRecordRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CreditCashFlowService creditCashFlowService;
    @Autowired(required=false)
    private CreditFileService creditFileService;

    @Transactional
    public void onCreate(List<CreditEventVo> voList) {
        Validate.isTrue((!CollectionUtils.isEmpty(voList) ? 1 : 0) != 0, (String)"\u65b0\u589e\u7684\u6388\u4fe1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        ArrayList fileModelDtoList = Lists.newArrayList();
        voList.forEach(creditEventVo -> {
            if (!ProcessStatusEnum.PASS.getDictCode().equals(creditEventVo.getProcessStatus())) {
                return;
            }
            CashAdjustOperateEnum adjustOperate = CreditType.NORMAL_CREDIT.getDictCode().equals(creditEventVo.getCreditType()) ? CashAdjustOperateEnum.OPEN_CREDIT : CashAdjustOperateEnum.TEMPORARY_CREDIT;
            CashAdjustTypeEnum adjustType = CreditType.NORMAL_CREDIT.getDictCode().equals(creditEventVo.getCreditType()) ? CashAdjustTypeEnum.OPEN_CREDIT : CashAdjustTypeEnum.TEMPORARY_CREDIT;
            CreditRecordEntity entity = (CreditRecordEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(creditEventVo, CreditRecordEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setCreditId(creditEventVo.getId());
            entity.setId(null);
            CreditCreateCashDto cashFlowDto = new CreditCreateCashDto();
            cashFlowDto.setCreditId(creditEventVo.getId());
            cashFlowDto.setCreditType(creditEventVo.getCreditType());
            cashFlowDto.setOperateAmount(creditEventVo.getCreditAmount());
            cashFlowDto.setCustomerCode(creditEventVo.getCustomerCode());
            cashFlowDto.setAdjustOperateCode(adjustOperate.getDictCode());
            cashFlowDto.setAdjustOperateName(adjustOperate.getValue());
            cashFlowDto.setAdjustTypeCode(adjustType.getDictCode());
            cashFlowDto.setAdjustTypeName(adjustType.getValue());
            CreditCashFlowEntity cashFlowEntity = this.creditCashFlowService.create((AbstractCreditCashFlowDto)cashFlowDto);
            entity.setCashSerialNumber(cashFlowEntity.getCashSerialNumber());
            this.creditRecordRepository.save((Object)entity);
            CreditFileModelDto fileModelDto = new CreditFileModelDto();
            fileModelDto.setFileType(CreditFileType.CREDIT_RECORD.getDictCode());
            fileModelDto.setBusinessId(entity.getId());
            if (!CollectionUtils.isEmpty((Collection)creditEventVo.getFileList())) {
                List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)creditEventVo.getFileList(), CreditFileVo.class, CreditFileDto.class, HashSet.class, ArrayList.class, new String[0]);
                fileModelDto.setFileList(list);
            }
            fileModelDtoList.add(fileModelDto);
        });
        if (!CollectionUtils.isEmpty((Collection)fileModelDtoList)) {
            this.creditFileService.update(fileModelDtoList);
        }
    }

    @Transactional
    public void onUpdate(CreditEventVo oldVo, CreditEventVo newVo) {
        Validate.isTrue((Objects.nonNull(oldVo) && Objects.nonNull(newVo) ? 1 : 0) != 0, (String)"\u66f4\u65b0\u524d\u548c\u66f4\u65b0\u540e\u6388\u4fe1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (!ProcessStatusEnum.PASS.getDictCode().equals(newVo.getProcessStatus())) {
            return;
        }
        CashAdjustOperateEnum adjustOperate = CashAdjustOperateEnum.CHANGE_CREDIT;
        CashAdjustTypeEnum adjustType = CashAdjustTypeEnum.CHANGE_CREDIT;
        CreditRecordEntity entity = (CreditRecordEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)newVo, CreditRecordEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setCreditId(newVo.getId());
        entity.setId(null);
        CreditUpdateCashDto cashFlowDto = new CreditUpdateCashDto();
        cashFlowDto.setCreditId(newVo.getId());
        cashFlowDto.setOperateAmount(newVo.getCreditAmount().subtract(oldVo.getCreditAmount()));
        cashFlowDto.setCustomerCode(newVo.getCustomerCode());
        cashFlowDto.setAdjustOperateCode(adjustOperate.getDictCode());
        cashFlowDto.setAdjustOperateName(adjustOperate.getValue());
        cashFlowDto.setAdjustTypeCode(adjustType.getDictCode());
        cashFlowDto.setAdjustTypeName(adjustType.getValue());
        CreditCashFlowEntity cashFlowEntity = this.creditCashFlowService.create((AbstractCreditCashFlowDto)cashFlowDto);
        entity.setCashSerialNumber(cashFlowEntity.getCashSerialNumber());
        this.creditRecordRepository.save((Object)entity);
        CreditFileModelDto fileModelDto = new CreditFileModelDto();
        fileModelDto.setFileType(CreditFileType.CREDIT_RECORD.getDictCode());
        fileModelDto.setBusinessId(entity.getId());
        if (!CollectionUtils.isEmpty((Collection)newVo.getFileList())) {
            List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)newVo.getFileList(), CreditFileVo.class, CreditFileDto.class, HashSet.class, ArrayList.class, new String[0]);
            fileModelDto.setFileList(list);
        }
        this.creditFileService.update(Lists.newArrayList((Object[])new CreditFileModelDto[]{fileModelDto}));
    }

    public void onDisable(List<CreditEventVo> voList) {
    }

    public void onEnable(List<CreditEventVo> voList) {
    }

    @Transactional
    public void onApprove(List<CreditEventVo> voList) {
        Validate.isTrue((!CollectionUtils.isEmpty(voList) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u7684\u6388\u4fe1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        ArrayList fileModelDtoList = Lists.newArrayList();
        voList.forEach(creditEventVo -> {
            if (!ProcessStatusEnum.PASS.getDictCode().equals(creditEventVo.getProcessStatus())) {
                return;
            }
            CashAdjustOperateEnum adjustOperate = CreditType.NORMAL_CREDIT.getDictCode().equals(creditEventVo.getCreditType()) ? CashAdjustOperateEnum.OPEN_CREDIT : CashAdjustOperateEnum.TEMPORARY_CREDIT;
            CashAdjustTypeEnum adjustType = CreditType.NORMAL_CREDIT.getDictCode().equals(creditEventVo.getCreditType()) ? CashAdjustTypeEnum.OPEN_CREDIT : CashAdjustTypeEnum.TEMPORARY_CREDIT;
            CreditRecordEntity entity = (CreditRecordEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(creditEventVo, CreditRecordEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setId(null);
            entity.setCreditId(creditEventVo.getId());
            CreditCreateCashDto cashFlowDto = new CreditCreateCashDto();
            cashFlowDto.setCreditId(creditEventVo.getId());
            cashFlowDto.setCreditType(creditEventVo.getCreditType());
            cashFlowDto.setOperateAmount(creditEventVo.getCreditAmount());
            cashFlowDto.setCustomerCode(creditEventVo.getCustomerCode());
            cashFlowDto.setAdjustOperateCode(adjustOperate.getDictCode());
            cashFlowDto.setAdjustOperateName(adjustOperate.getValue());
            cashFlowDto.setAdjustTypeCode(adjustType.getDictCode());
            cashFlowDto.setAdjustTypeName(adjustType.getValue());
            CreditCashFlowEntity cashFlowEntity = this.creditCashFlowService.create((AbstractCreditCashFlowDto)cashFlowDto);
            entity.setCashSerialNumber(cashFlowEntity.getCashSerialNumber());
            this.creditRecordRepository.save((Object)entity);
            CreditFileModelDto fileModelDto = new CreditFileModelDto();
            fileModelDto.setFileType(CreditFileType.CREDIT_RECORD.getDictCode());
            fileModelDto.setBusinessId(entity.getId());
            if (!CollectionUtils.isEmpty((Collection)creditEventVo.getFileList())) {
                List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)creditEventVo.getFileList(), CreditFileVo.class, CreditFileDto.class, HashSet.class, ArrayList.class, new String[0]);
                fileModelDto.setFileList(list);
            }
            fileModelDtoList.add(fileModelDto);
        });
        if (!CollectionUtils.isEmpty((Collection)fileModelDtoList)) {
            this.creditFileService.update(fileModelDtoList);
        }
    }
}

