/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.register;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditDownUpAccountEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditFileEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowItemRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditDownUpAccountRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditDownUpAccountCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditFileVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class CreditDownUpAccountCashFlowRegisterImpl
implements CreditCashFlowRegister<CreditDownUpAccountCashDto> {
    @Autowired(required=false)
    private CreditCashFlowItemRepository creditCashFlowItemRepository;
    @Autowired(required=false)
    private CreditCashRepository creditCashRepository;
    @Autowired(required=false)
    private CreditDownUpAccountRepository creditDownUpAccountRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Class<CreditDownUpAccountCashDto> getClazz() {
        return CreditDownUpAccountCashDto.class;
    }

    @Transactional
    public List<CreditCashVo> onCreate(CreditDownUpAccountCashDto dto) {
        Validate.notBlank((CharSequence)dto.getCreditId(), (String)"\u7f3a\u5931\u6388\u4fe1ID", (Object[])new Object[0]);
        CreditCashEntity nowCashEntity = this.creditCashRepository.findByCreditId(dto.getCreditId());
        Validate.notNull((Object)((Object)nowCashEntity), (String)"\u6388\u4fe1\u8d44\u91d1\u5f02\u5e38!", (Object[])new Object[0]);
        if (dto.getOperateAmount().compareTo(BigDecimal.ZERO) > 0) {
            Validate.isTrue((nowCashEntity.getFreezeAmount().add(nowCashEntity.getOccupyAmount()).add(dto.getOperateAmount()).add(nowCashEntity.getCanUseAmount()).compareTo(nowCashEntity.getCreditAmount()) <= 0 ? 1 : 0) != 0, (String)String.format("\u56de\u6b3e/\u4e0a\u8d26\u91d1\u989d\u8d85\u8fc7\u53ef\u91ca\u653e\u6700\u5927\u989d\u5ea6,\u65e0\u6cd5\u6267\u884c[%s]\u64cd\u4f5c", dto.getAdjustOperateName()), (Object[])new Object[0]);
        } else {
            Validate.isTrue((dto.getOperateAmount().add(nowCashEntity.getCanUseAmount()).compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)String.format("\u56de\u6b3e/\u4e0a\u8d26\u91d1\u989d\u8d85\u8fc7\u53ef\u4f7f\u7528\u6700\u5927\u989d\u5ea6,\u65e0\u6cd5\u6267\u884c[%s]\u64cd\u4f5c", dto.getAdjustOperateName()), (Object[])new Object[0]);
        }
        nowCashEntity.setCanUseAmount(nowCashEntity.getCanUseAmount().add(dto.getOperateAmount()));
        this.creditCashRepository.updateById((Object)nowCashEntity);
        CreditCashFlowItemEntity cashFlowItemEntity = new CreditCashFlowItemEntity();
        cashFlowItemEntity.setTenantCode(dto.getTenantCode());
        cashFlowItemEntity.setCreditId(dto.getCreditId());
        cashFlowItemEntity.setItemAmount(dto.getOperateAmount());
        cashFlowItemEntity.setCashFlowId(dto.getId());
        this.creditCashFlowItemRepository.save((Object)cashFlowItemEntity);
        return Lists.newArrayList((Object[])new CreditCashVo[]{(CreditCashVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)nowCashEntity, CreditCashVo.class, HashSet.class, ArrayList.class, new String[0])});
    }

    public List<CreditCashFlowExtendVo> onRequestByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newLinkedList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<CreditDownUpAccountEntity> entities = this.creditDownUpAccountRepository.findByCreditCashFlowExtendDto(dto);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        return entities.stream().map(entity -> {
            CreditCashFlowExtendVo extendVo = new CreditCashFlowExtendVo();
            extendVo.setCashSerialNumber(entity.getCashSerialNumber());
            extendVo.setRemark(entity.getRemark());
            extendVo.setOrderCode(entity.getOrderCode());
            extendVo.setOrderType(entity.getOrderType());
            if (!CollectionUtils.isEmpty(entity.getFileList())) {
                List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entity.getFileList(), CreditFileEntity.class, CreditFileVo.class, HashSet.class, ArrayList.class, new String[0]);
                extendVo.setFileList(voList);
            }
            return extendVo;
        }).collect(Collectors.toList());
    }
}

