/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.register;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditOccupyEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditPayEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowItemRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditOccupyRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditPayRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditPayCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.OccupyTypeEnum;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class CreditNewPayCashFlowRegisterImpl
implements CreditCashFlowRegister<CreditPayCashDto> {
    @Autowired(required=false)
    private CreditOccupyRepository creditOccupyRepository;
    @Autowired(required=false)
    private CreditCashFlowRepository creditCashFlowRepository;
    @Autowired(required=false)
    private CreditCashFlowItemRepository creditCashFlowItemRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CreditCashRepository creditCashRepository;
    @Autowired(required=false)
    private CreditPayRepository creditPayRepository;

    public Class<CreditPayCashDto> getClazz() {
        return CreditPayCashDto.class;
    }

    @Transactional
    public List<CreditCashVo> onCreate(CreditPayCashDto dto) {
        CreditOccupyEntity creditOccupyEntity = this.creditOccupyRepository.findOccupyByOccupyTypeAndBusinessOrderCode(TenantUtils.getTenantCode(), OccupyTypeEnum.OCCUPY, dto.getFromCode());
        Validate.notNull((Object)((Object)creditOccupyEntity), (String)"\u672a\u627e\u5230\u6388\u4fe1\u5360\u7528\u4fe1\u606f\uff0c\u65e0\u6cd5\u6267\u884c\u6263\u51cf\u903b\u8f91\uff01", (Object[])new Object[0]);
        List<CreditCashFlowEntity> creditCashFlowEntities = this.creditCashFlowRepository.findByCashSerialNumbers(Collections.singletonList(creditOccupyEntity.getCashSerialNumber()), TenantUtils.getTenantCode());
        Validate.notEmpty(creditCashFlowEntities, (String)"\u672a\u627e\u5230\u6388\u4fe1\u5360\u7528\u8d44\u91d1\u6d41\u6c34\u4fe1\u606f\uff0c\u65e0\u6cd5\u6267\u884c\u6263\u51cf\u903b\u8f91\uff01", (Object[])new Object[0]);
        CreditCashFlowEntity creditCashFlowEntity = creditCashFlowEntities.get(0);
        List<CreditCashFlowItemEntity> creditCashFlowItemEntities = this.creditCashFlowItemRepository.findByCashFlowIds(Collections.singletonList(creditCashFlowEntity.getId()));
        Validate.notEmpty(creditCashFlowItemEntities, (String)"\u672a\u627e\u5230\u6388\u4fe1\u5360\u7528\u8d44\u91d1\u6d41\u6c34\u660e\u7ec6\uff0c\u65e0\u6cd5\u6267\u884c\u6263\u51cf\u903b\u8f91\uff01", (Object[])new Object[0]);
        String creditId = creditCashFlowItemEntities.get(0).getCreditId();
        CreditCashFlowItemEntity flowItemEntity = new CreditCashFlowItemEntity();
        flowItemEntity.setCashFlowId(dto.getId());
        flowItemEntity.setCreditId(creditId);
        flowItemEntity.setItemAmount(creditCashFlowEntity.getOperateAmount());
        flowItemEntity.setTenantCode(creditCashFlowEntity.getTenantCode());
        this.creditCashFlowItemRepository.save((Object)flowItemEntity);
        List<CreditCashEntity> creditCashEntities = this.creditCashRepository.findByCreditIds(Collections.singletonList(creditId));
        Validate.notEmpty(creditCashEntities, (String)"\u672a\u627e\u5230\u6388\u4fe1\u8d44\u91d1\u4fe1\u606f", (Object[])new Object[0]);
        creditCashEntities.forEach(creditCashEntity -> creditCashEntity.setCanUseAmount(creditCashEntity.getCanUseAmount().add(creditCashFlowEntity.getOperateAmount())));
        this.creditCashRepository.updateBatchById(creditCashEntities);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(creditCashEntities, CreditCashEntity.class, CreditCashVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CreditCashFlowExtendVo> onRequestByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newLinkedList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<CreditPayEntity> entities = this.creditPayRepository.findByCreditCashFlowExtendDto(dto);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        return entities.stream().map(entity -> {
            CreditCashFlowExtendVo extendVo = new CreditCashFlowExtendVo();
            extendVo.setCashSerialNumber(entity.getCashSerialNumber());
            extendVo.setOrderCode(entity.getBusinessOrderCode());
            extendVo.setRemark(entity.getRemark());
            extendVo.setOrderType(entity.getOrderType());
            return extendVo;
        }).collect(Collectors.toList());
    }
}

