/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.register;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditFileEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditRecordEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowItemRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditRecordRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditUpdateCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.enums.CreditType;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditFileVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class CreditUpdateCashFlowRegisterImpl
implements CreditCashFlowRegister<CreditUpdateCashDto> {
    @Autowired(required=false)
    private CreditCashFlowItemRepository creditCashFlowItemRepository;
    @Autowired(required=false)
    private CreditCashRepository creditCashRepository;
    @Autowired(required=false)
    private CreditRecordRepository creditRecordRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Class<CreditUpdateCashDto> getClazz() {
        return CreditUpdateCashDto.class;
    }

    @Transactional
    public List<CreditCashVo> onCreate(CreditUpdateCashDto dto) {
        Validate.notBlank((CharSequence)dto.getCreditId(), (String)"\u7f3a\u5931\u6388\u4fe1ID", (Object[])new Object[0]);
        CreditCashEntity nowCashEntity = this.creditCashRepository.findByCreditId(dto.getCreditId());
        if (dto.getOperateAmount().compareTo(BigDecimal.ZERO) < 0) {
            Validate.isTrue((Objects.nonNull((Object)nowCashEntity) && nowCashEntity.getCanUseAmount().add(dto.getOperateAmount()).compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)String.format("\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3,\u65e0\u6cd5\u6267\u884c[%s]\u64cd\u4f5c", dto.getAdjustOperateName()), (Object[])new Object[0]);
        }
        nowCashEntity.setCanUseAmount(nowCashEntity.getCanUseAmount().add(dto.getOperateAmount()));
        nowCashEntity.setCreditAmount(nowCashEntity.getCreditAmount().add(dto.getOperateAmount()));
        this.creditCashRepository.updateById((Object)nowCashEntity);
        CreditCashFlowItemEntity cashFlowItemEntity = new CreditCashFlowItemEntity();
        cashFlowItemEntity.setTenantCode(dto.getTenantCode());
        cashFlowItemEntity.setCreditId(dto.getCreditId());
        cashFlowItemEntity.setItemAmount(dto.getOperateAmount());
        cashFlowItemEntity.setCashFlowId(dto.getId());
        this.creditCashFlowItemRepository.save((Object)cashFlowItemEntity);
        return Lists.newArrayList((Object[])new CreditCashVo[]{(CreditCashVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)nowCashEntity, CreditCashVo.class, HashSet.class, ArrayList.class, new String[0])});
    }

    public List<CreditCashFlowExtendVo> onRequestByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
        if (Objects.isNull(dto) || !CollectionUtils.isEmpty((Collection)dto.getOrderCodes())) {
            return Lists.newLinkedList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<CreditRecordEntity> entities = this.creditRecordRepository.findByCreditCashFlowExtendDto(dto);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        return entities.stream().map(entity -> {
            CreditCashFlowExtendVo extendVo = new CreditCashFlowExtendVo();
            extendVo.setCashSerialNumber(entity.getCashSerialNumber());
            extendVo.setRemark(entity.getRemark());
            extendVo.setTemporaryAmount(CreditType.TEMPORARY_CREDIT.getDictCode().equals(entity.getCreditType()) ? entity.getCreditAmount() : null);
            if (!CollectionUtils.isEmpty(entity.getFileList())) {
                List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entity.getFileList(), CreditFileEntity.class, CreditFileVo.class, HashSet.class, ArrayList.class, new String[0]);
                extendVo.setFileList(voList);
            }
            return extendVo;
        }).collect(Collectors.toList());
    }
}

