/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.credit.local.service.register;

import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashEntity;
import com.biz.crm.dms.business.costpool.credit.local.entity.CreditCashFlowItemEntity;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashFlowItemRepository;
import com.biz.crm.dms.business.costpool.credit.local.repository.CreditCashRepository;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditCashFlowExtendDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.dto.CreditWriteOffItemCashDto;
import com.biz.crm.dms.business.costpool.credit.sdk.register.CreditCashFlowRegister;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashFlowExtendVo;
import com.biz.crm.dms.business.costpool.credit.sdk.vo.CreditCashVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class CreditWriteOffCashFlowRegisterImpl
implements CreditCashFlowRegister<CreditWriteOffCashDto> {
    @Autowired(required=false)
    private CreditCashFlowItemRepository creditCashFlowItemRepository;
    @Autowired(required=false)
    private CreditCashRepository creditCashRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Class<CreditWriteOffCashDto> getClazz() {
        return CreditWriteOffCashDto.class;
    }

    @Transactional
    public List<CreditCashVo> onCreate(CreditWriteOffCashDto dto) {
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getWriteOffItemList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u6388\u4fe1\u6838\u9500\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[0]);
        List<String> creditIds = dto.getWriteOffItemList().stream().map(CreditWriteOffItemCashDto::getCreditId).collect(Collectors.toList());
        List<CreditCashEntity> cashEntities = this.creditCashRepository.findByCreditIds(creditIds);
        Validate.isTrue((!CollectionUtils.isEmpty(cashEntities) ? 1 : 0) != 0, (String)"\u6388\u4fe1\u8d44\u91d1\u5f02\u5e38!", (Object[])new Object[0]);
        Map<String, CreditCashEntity> cashEntityMap = cashEntities.stream().collect(Collectors.toMap(CreditCashEntity::getCreditId, t -> t));
        ArrayList updateCashEntities = Lists.newArrayList();
        ArrayList saveFlowItemEntities = Lists.newArrayList();
        dto.getWriteOffItemList().forEach(cashDto -> {
            CreditCashEntity cashEntity = (CreditCashEntity)((Object)((Object)cashEntityMap.get(cashDto.getCreditId())));
            Validate.notNull((Object)((Object)cashEntity), (String)"\u6388\u4fe1\u8d44\u91d1\u5f02\u5e38!", (Object[])new Object[0]);
            BigDecimal waitWriteOffAmount = cashEntity.getCreditAmount().subtract(cashEntity.getFreezeAmount()).subtract(cashEntity.getCanUseAmount());
            BigDecimal remainWriteOffAmount = waitWriteOffAmount.subtract(cashDto.getWriteOffAmount());
            Validate.isTrue((remainWriteOffAmount.compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)String.format("\u6838\u9500\u989d\u5ea6\u8d85\u8fc7\u5f85\u6838\u9500\u989d\u5ea6,\u65e0\u6cd5\u6267\u884c[%s]\u64cd\u4f5c", dto.getAdjustOperateName()), (Object[])new Object[0]);
            cashEntity.setWriteOffAmount(cashEntity.getWriteOffAmount().add(cashDto.getWriteOffAmount()));
            cashEntity.setCanUseAmount(cashEntity.getCanUseAmount().add(cashDto.getWriteOffAmount()));
            updateCashEntities.add(cashEntity);
            CreditCashFlowItemEntity cashFlowItemEntity = new CreditCashFlowItemEntity();
            cashFlowItemEntity.setTenantCode(dto.getTenantCode());
            cashFlowItemEntity.setCreditId(cashDto.getCreditId());
            cashFlowItemEntity.setItemAmount(cashDto.getWriteOffAmount());
            cashFlowItemEntity.setCashFlowId(dto.getId());
            saveFlowItemEntities.add(cashFlowItemEntity);
        });
        this.creditCashRepository.updateBatchById(updateCashEntities);
        this.creditCashFlowItemRepository.saveBatch(saveFlowItemEntities);
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(cashEntities, CreditCashEntity.class, CreditCashVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CreditCashFlowExtendVo> onRequestByCreditCashFlowExtendDto(CreditCashFlowExtendDto dto) {
        return Lists.newLinkedList();
    }
}

