package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.biz.crm.business.common.sdk.dto.WorkflowFlagOpDto;
import com.biz.crm.workflow.sdk.vo.AttachmentVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 授信Dto
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditDto", description = "授信Dto")
public class CreditDto extends WorkflowFlagOpDto {

  /**
   * 授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))
   */
  @ApiModelProperty("授信类型(授信类型(normalCredit:普通授信,temporaryCredit:临时授信))")
  private String creditType;

  /**
   * 客户编码集合
   */
  @ApiModelProperty("客户编码集合")
  private List<String> customerCodeList;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 授信额度
   */
  @ApiModelProperty("授信额度")
  private BigDecimal creditAmount;

  /**
   * 授信开始时间
   */
  @ApiModelProperty("授信开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditStartTime;

  /**
   * 授信结束时间
   */
  @ApiModelProperty("授信结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditEndTime;

  /**
   * 还款截止时间
   */
  @ApiModelProperty("还款截止时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date repayEndTime;

  /**
   * 授信文件信息集合
   */
  @ApiModelProperty("授信文件信息集合")
  private List<CreditFileDto> fileList;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 流程附件信息
   */
  @ApiModelProperty(value = "流程附件信息")
  private List<AttachmentVo> attachmentVos;

  /**
   * 授信编码
   */
  @ApiModelProperty("授信编码")
  private String creditCode;

  /**
   * 是否提交审批流程(true:是,false:否)
   */
  @ApiModelProperty("是否提交审批流程(true:是,false:否)")
  private Boolean submitProcess;
}
