package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 授信资金占用流水操作请求dto
 *
 * @author pengxi
 * @date 2022/6/24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditRefundCashDto", description = "授信资金占用流水操作请求dto")
public class CreditOccupyCashDto extends AbstractCreditCashFlowDto {

  /**
   * 业务单据号
   */
  @ApiModelProperty("业务单据号")
  private String businessOrderCode;

  /**
   * 占用类型：occupy 占用；release 释放
   */
  @ApiModelProperty("占用类型：occupy 占用；release 释放")
  private String occupyType;
}
