package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 授信资金占用操作请求dto
 *
 * @author pengxi
 * @date 2022/6/24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditOccupyDto", description = "授信资金占用操作请求dto")
public class CreditOccupyDto extends CostPoolDto {

  private static final long serialVersionUID = -1262658725270650261L;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 调整类型编码
   */
  @ApiModelProperty("调整类型编码")
  private String adjustTypeCode;

  /**
   * 调整操作编码
   */
  @ApiModelProperty("调整操作编码")
  private String adjustOperateCode;

}
