package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 普通授信分页列表查询dto
 *
 * @author ning.zhang
 * @date 2021/12/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditPageDto", description = "普通授信分页列表查询dto")
public class CreditPageDto extends TenantDto {

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 授信开始时间
   */
  @ApiModelProperty("授信开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditStartTime;

  /**
   * 授信结束时间
   */
  @ApiModelProperty("授信结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date creditEndTime;

  /**
   * 授信ID集合
   */
  @ApiModelProperty("授信ID集合")
  private List<String> creditIdList;

}
