package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 授信资金支付操作请求dto
 *
 * @author ning.zhang
 * @date 2022/1/20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditPayDto", description = "授信资金支付操作请求dto")
public class CreditPayDto extends CostPoolDto {

  private static final long serialVersionUID = -4617641557539711027L;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   * 调整类型编码
   */
  @ApiModelProperty("调整类型编码")
  private String adjustTypeCode;

  /**
   * 调整操作编码
   */
  @ApiModelProperty("调整操作编码")
  private String adjustOperateCode;
}
