package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 授信对账函数据统计dto
 *
 * @author ning.zhang
 * @date 2021/12/23
 */
@Data
@ApiModel(value = "CreditReconcileStatsDto", description = "授信对账函数据统计dto")
public class CreditReconcileStatsDto extends TenantDto {

  /**
   * 授信开始时间
   */
  @ApiModelProperty("开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /**
   * 授信结束时间
   */
  @ApiModelProperty("结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;
}
