package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 通知授信还款请求Dto
 *
 * @author ning.zhang
 * @date 2021/12/21
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditRepayNoticeDto", description = "通知授信还款请求Dto")
public class CreditRepayNoticeDto extends TenantDto {

  /**
   * 标题
   */
  @ApiModelProperty(value = "标题")
  private String title;
  /**
   * 类型
   */
  @ApiModelProperty(value = "类型")
  private String type;
  /**
   * 生效开始时间
   */
  @ApiModelProperty("生效开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;
  /**
   * 生效结束时间
   */
  @ApiModelProperty("生效结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;
  /**
   * 还款开始时间
   */
  @ApiModelProperty("还款开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date repayStartTime;
  /**
   * 生效结束时间
   */
  @ApiModelProperty("还款结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date repayEndTime;
  /**
   * 首页是否弹出
   */
  @ApiModelProperty("首页是否弹出")
  private Boolean indexPopup;
  /**
   * 弹出类型(readNotPopup:已阅读后不弹出,everyLoginPopup:每次登陆都弹出)
   */
  @ApiModelProperty("弹出类型(readNotPopup:已阅读后不弹出,everyLoginPopup:每次登陆都弹出)")
  private String popupType;
  /**
   * 公告内容
   */
  @ApiModelProperty(value = "公告内容")
  private String content;

}
