package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 授信客户分页请求dto
 *
 * @author ning.zhang
 * @date 2022/1/17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditTemporaryCustomerPageDto", description = "授信客户分页请求dto")
public class CreditTemporaryCustomerPageDto extends TenantDto {

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 当前时间
   */
  @ApiModelProperty("当前时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date nowDate;
}
