package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 授信核销请求Dto
 *
 * @author ning.zhang
 * @date 2021/12/21
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditWriteOffDto", description = "授信核销请求Dto")
public class CreditWriteOffDto extends TenantDto {

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 核销详细信息
   */
  @ApiModelProperty("核销详细信息")
  private List<CreditWriteOffInfoDto> writeOffInfoList;
}
