package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 授信核销详细信息Dto
 *
 * @author ning.zhang
 * @date 2021/12/21
 */
@Data
@ApiModel(value = "CreditWriteOffInfoDto", description = "授信核销详细信息Dto")
public class CreditWriteOffInfoDto {

  /**
   * 授信ID(如果是一个,表示单个授信使用orderList,如果是多少,表示多用授信共用orderList)
   */
  @ApiModelProperty("授信ID(如果是一个,表示单个授信使用orderList,如果是多少,表示多用授信共用orderList)")
  private List<String> creditIds;

  /**
   * 核销单据信息
   */
  @ApiModelProperty("核销单据信息")
  private List<CreditWriteOffOrderDto> orderList;
}
