package com.biz.crm.dms.business.costpool.credit.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 授信核销明细资金操作请求dto
 *
 * @author ning.zhang
 * @date 2021/12/1
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CreditWriteOffItemCashDto", description = "授信核销明细资金操作请求dto")
public class CreditWriteOffItemCashDto {

  /**
   * 授信ID
   */
  @ApiModelProperty(value = "授信ID")
  private String creditId;

  /**
   * 授信编码
   */
  @ApiModelProperty("授信编码")
  private BigDecimal creditCode;

  /**
   * 核销金额
   */
  @ApiModelProperty("核销金额")
  private BigDecimal writeOffAmount;

}
